/*
Jesus Christ is the only savior, who will redeem you.
യേശുക്രിസ്തു മാത്രമാണ് രക്ഷകൻ , അവൻ നിങ്ങളെ വീണ്ടെടുക്കും.
ישוע המשיח היחיד שיגאל אותך.

 All honor and glory and thanks and praise and worship belong to him, my Lord Jesus Christ.
സകല മഹത്വവും ബഹുമാനവും സ്തോത്രവും സ്തുതിയും ആരാധനയും എന്റെ കർത്താവായ യേശുക്രിസ്തുവിന് എന്നേക്കും ഉണ്ടായിരിക്കട്ടെ.
כל הכבוד והתהילה והשבחים והשבחים שייכים לו, אדוננו ישוע המשיח.

*/
//Vanila Virtual List v1.0
//Thanks to Michael Leibman - SlickGrid v2.2 , some ideas borrowed from him.
var scrollbarDimensions;
var maxSupportedCssHeight;  // browser's breaking point

function calc_str_wh(str,font_size,parent){
	var test = document.getElementById("calc_str_wh");
	if(!test){
		test=document.createElement('div');
		test.id="calc_str_wh";
		test.style.cssText='position:absolute;visibility:hidden;height:auto;width:auto;white-space:nowrap;';
		parent.appendChild(test);
	}
	//test.style.display='';
	font_size=font_size===undefined?14:font_size;
	test.style.fontSize = font_size;
	test.innerHTML=str;
	var width = (test.clientWidth+1);
	var height = (test.clientHeight+1);
	//test.innerHTML='';
	//test.style.display='none';
	return {w:width,h:height};
}
function getMaxSupportedCssHeight() {
  var supportedHeight = 1000000;
  // FF reports the height back but still renders blank after ~6M px
  var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
  var testUpTo = isFirefox? 6000000 : 1000000000;
  var div =document.createElement('div');
	div.style.display='none';
  document.body.appendChild(div);
  
  while (true) {
	var test = supportedHeight * 2;
	div.style.height=test+'px';
	var style = window.getComputedStyle(div);
	var height=parseFloat(style.getPropertyValue('height'));
	if (test > testUpTo || height !== test) {
	  break;
	} else {
	  supportedHeight = test;
	}
  }
	document.body.removeChild(div);
  return supportedHeight;
}
function measureScrollbar() {
  var div =document.createElement('div');
	div.style.cssText='position:absolute; top:-10000px; left:-10000px; width:100px; height:100px; overflow:scroll;';
   document.body.appendChild(div);
  var dim = {
	width: div.offsetWidth - div.clientWidth,
	height: div.offsetHeight - div.clientHeight
  };
  document.body.removeChild(div);
  return dim;
}
function easeInOutQuad(t){ return t<.5 ? 2*t*t : -1+(4-2*t)*t };
function scrollTo(element, to, duration, onDone) {
    var start = element.scrollTop,
        change = to - start,
        startTime = performance.now(),
        val, now, elapsed, t;
    function animateScroll(){
        now = performance.now();
        elapsed = (now - startTime)/1000;
        t = (elapsed/duration);
        element.scrollTop = start + change * easeInOutQuad(t);
        if( t < 1 ){
            window.requestAnimationFrame(animateScroll);
        }else{
            onDone && onDone();
		}
    };
    animateScroll();
}
var data_table_id=0;
function data_table(div_container,cols,data,options){
	var html='';
		html+='<div class="_box" style="display: flex;flex-flow: column;height: 100%;">';
		html+='	<div class="header" style="flex: 0 1 auto;z-index:1;display: flex;">';
		html+='		<table class="table_header" style="position2:sticky;top2:0;table-layout:fixed;">';
		html+='			<thead></thead>';
		html+='		</table>';
		html+='		<span class="scroll_bar_holder" style="width:0px;background-color:dimgray;" ></span>';
		html+='	</div>';
		html+='	<div class="content scroller" style="flex: 1 1 auto;overflow-y:scroll;z-index:0;overflow-x:hidden;padding:0px;">';
		html+='  	<div class="body" style="position:relative;width:100%;height:auto;">';
		html+='  	</div>';
		html+='  	<div class="body_preloader" style="display:none;position:absolute;height:64px;width:100%;left:0;right:0;top:0;bottom:0;margin:auto;max-width:100%;max-height:100%;overflow:auto;background-repeat: no-repeat;background-position: center;">';
		html+='  	</div>';
		html+='	</div>';
		html+='	<div class="footer" style="flex: 0 1 auto;z-index:1;">';
		html+='		<table class="table_footer" style="position2:sticky;bottom2:0;table-layout:fixed;">';
		html+='			<tfoot></tfoot>';
		html+='		</table>';
		html+='	</div>';
		html+='</div>';
	var modal_html='';
		modal_html+='<div class="modal">';
		modal_html+='  <div class="modal-bg modal-exit"></div>';
		modal_html+='  <div class="modal-container">';
		modal_html+='  	<div class="modal-content" >';
		modal_html+='			<h1>Amazing Modal</h1>';
		modal_html+='			<h2>Pure Vanilla JavaScript</h2>';
		modal_html+='  	</div>';
		modal_html+='		<button tabIndex=0 class="button button-fill button-round modal-close modal-exit">X</button>';
		modal_html+='  </div>';
		modal_html+='</div>';
			data_table_id++;
	this.name='data_table';
	this.id='data_table_' + data_table_id;
	this.div=div_container;
	this.div.innerHTML=html;
	this.div.style.overflow='hidden';
	this.table_header=this.div.querySelector('.table_header');
	this.scroller=this.div.querySelector('.scroller');
	this.table_body=this.div.querySelector('.body');
	this.body_preloader=this.div.querySelector('.body_preloader');
	this.footer=this.div.querySelector('.footer');
	this.table_footer=this.div.querySelector('.table_footer');
		var modal_parent=document.body;
		if(options && options.modal_parent){
			if(typeof(options.modal_parent)==='string'){
				modal_parent=document.querySelector(options.modal_parent);
			}else{
				modal_parent=options.modal_parent;
			}
		}
	this.modal_parent=modal_parent;
		//if(!modal_parent.querySelector('.modal')){
			var div=document.createElement('div');
			div.innerHTML=modal_html;
			modal_parent.appendChild(div);
			//	div.outerHTML=modal_html;
		//}
	this.modal_div=div;
	//this.modal=modal_parent.querySelector('.modal');
	this.modal=div.querySelector('.modal');
	this.require_render_header=true;
	this.cols=cols;
	this.data=data;
	this.filter=[];
	this.options=options || {};
	this.search='';
	this.events=[];
	this.col_filter=[];
	this.sum_cols=0;
	this.maxw=0;
	this.all_cols_visible=false;
	this.virtual=true;
	this.single_row_height=0;
	this.start_index=0;
	this.end_index=0;
	this.last_scrollTop=0;
	this.dynamic_height=true;
	this.hCells=[];
		maxSupportedCssHeight = maxSupportedCssHeight || getMaxSupportedCssHeight();
		scrollbarDimensions = scrollbarDimensions || measureScrollbar();

	this.maxSupportedCssHeight=maxSupportedCssHeight;
	this.offset=0;
	this.visible_items=0;
	this.sort_icon='&nbsp; <i class="f7-icons sort_col">sort_down_circle</i>';
	this.sort_down_icon='&nbsp; <i class="f7-icons sort_col">sort_down</i>';
	this.sort_up_icon='&nbsp; <i class="f7-icons sort_col">sort_up</i>';
	this.scrollbarDimensions=scrollbarDimensions;
	this.auto_hide_footer=0;
	this.modal_col_title_style='width:50%;';
	this.modal_col_data_style='width:50%;';
	this.rows=[];
	//this.responsive=true;
	this.prepare_data=function(){
		var sortBy=[];
		this.trigger('before_prepare_data',[]);
		if(this.filter.length===0){
			//this.filter=this.data.slice(0,this.data.length);
			//this.filter=this.data.splice(0,this.data.length);
			//this.filter= [...this.data];//faster   arr2 = [].concat(arr1)
			this.filter=this.data.slice(0);//fastest
		}
		var index_col=-1;
		for(var i=0;i<this.cols.length;i++){
			var col=this.cols[i];
			this.cols[i].sum=0;
			if(col.name==='index'){
				index_col=i;
			}
			if(col.sort_order){
				sortBy.push(this.cols[i]);
			}
			if(this.require_render_header){
				this.cols[i].colw=this.cols[i].width || 0;
			}
		}
		//for(var j=0;j<this.filter.length;j++){
		var l = this.filter.length;
		var j = 0;
		//this.data=[];
		this.data=new Array(l);
		var k=0;
		var _a_search=this.search.toLowerCase().split(' ');
		while (j < l) {
			var _data=this.filter[j];
				j++;
			var b=true;
			if(this.col_filter.length>0){
				for(var i=0;i<this.col_filter.length;i++){
					var _filter=this.col_filter[i];
					var cond=_filter.cond || 'and';
					var b2=false;
					if(isArray(_filter.val)){
						b2=_filter.val.filter(function(v){
							var _b=true;
							switch(_filter.func){
								case '=':
									_b=(v+'')==(_data[_filter.name]+'');
								break;
								case '>':
									_b=v<_data[_filter.name];
								break;
								case '<':
									_b=v>_data[_filter.name];
								break;
								default:
									_b=_filter.func.call(this,v,_data[_filter.name],_data,_filter);
								break;
							}
							return _b;
						}).length>0;
					}else{
						switch(_filter.func){
							case '=':
								b2=_filter.val==_data[_filter.name]+'';
							break;
							case '>':
								b2=_filter.val<_data[_filter.name];
							break;
							case '<':
								b2=_filter.val>_data[_filter.name];
							break;
							default:
								b2=_filter.func.call(this,_filter.val,_data[_filter.name],_data,_filter);
							break;
						}
					}
					switch(cond){
						case 'and':
							b=b && b2;
						break;
						case 'or':
							b=b || b2;
						break;
						case 'not':
							//b=!b2;
							b=b && !b2;
						break;
					}
				}
			}
			if(this.search && this.search.length>0){
				for(var i=0;i<this.cols.length;i++){
					var col=this.cols[i];
					if(col.on_search){
						b=col.on_search.call(this,this.search,col,_data,_a_search);
						if(b){
							break;
						}
					}else{
						if(col.type==='str' || col.searchable){
							if(_a_search.length>1){
								for(var kk=0;kk<_a_search.length;kk++){
									if(kk===0){
										b=(_data[col.name]+'').toLowerCase().indexOf(_a_search[kk])>-1;
									}else{
										b= b && (_data[col.name]+'').toLowerCase().indexOf(_a_search[kk])>-1;
									}
								}
							}else{
								b=(_data[col.name]+'').toLowerCase().indexOf(this.search)>-1;
							}
							if(b){
								break;
							}
						}
					}
				}
			}
			if(!b){
				continue;
			}
			for(var i=0;i<this.cols.length;i++){
				var col=this.cols[i];
				if(col.name==='index'){
					//cols[i].sum=(this.data.length+1);
					//if(j!==this.data.length){
					this.cols[i].sum=(k+1);
					
				}else{
					switch(col.type){	
						case 'num':case 'int':
							this.cols[i].sum+=getFloat(_data[col.name]);
						break;
						default:
							if(typeof(col.type)==='function'){
								var ret=col.type('prepare_data',_data[col.name],_data,i,j,col);
								if(ret && ret.value){
									_data[col.name]=ret.value;
									this.cols[i].sum+=ret.value;
								}
							}
						break;
					}
				}
			}
			_data.row_top=-1;
			_data.row_height=0;
			if(this.options && this.options.on_prepare_data){
				var _t=this.options.on_prepare_data.call(this,_data,j);
				if(_t){
					//_data=_t;
					for(var aa in _t){
						_data[aa]=_t[aa];
					}
				}
			}
			//this.data.push(_data);
			this.data[k]=_data;
			
			k++;
		}
		this.data.length=k;
		if(index_col!==-1 && l!==k){
			this.cols[index_col].sum=this.cols[index_col].sum+'('+ this.filter.length +')';
		}
		//console.log(sortBy);
		if(sortBy.length>0){
			sort_multi(this.data,sortBy);
		}
	};
	this.focus_row=function(filter_func){
		var sh=this.scroller.scrollHeight-this.scroller.offsetHeight;
		var p=0;
		var scrollTop=0;
		var pi=(this.scroller.offsetHeight/this.single_row_height)-1;
			var j = 0;
			if(filter_func && typeof(filter_func)==='function'){
				var l = this.data.length;
				while (j < l) {
					var _data=this.data[j];
					if(filter_func.call(this,_data)){
						break;
					}
					j++;
				}
			}else if(typeof(filter_func)==='number'){
				j=filter_func;
			}
		var row=this.table_body.querySelector('[row_index="'+j+'"]');
		if(sh>0){
			
			if(!this.virtual){
				this.div.scrollIntoView();
				//row.scrollIntoView();
				 var pPos = row.parentNode.getBoundingClientRect(), // parent pos
					cPos = row.getBoundingClientRect(), // target pos
					pos = {};
					pos.top    = cPos.top    - pPos.top + row.parentNode.scrollTop,
					pos.right  = cPos.right  - pPos.right,
					pos.bottom = cPos.bottom - pPos.bottom,
					pos.left   = cPos.left   - pPos.left;
				scrollTo(this.table_body,pos.top,1);  // duration in seconds
				return;
			}
			scrollTop=this.single_row_height*j;
			if(this.dynamic_height){
				scrollTop-=(this.single_row_height);
			}else{
				scrollTop-=(pi*this.single_row_height);
			}
			if(scrollTop<0){
				scrollTop=0;
			}
			this.scroller.scrollTop=scrollTop;
		}else{
			if(row){
				row.scrollIntoView({behavior:"instant",block:"center",inline:"center"});
			}
		}
	};
	this.remove_row=function(filter_func){
		var arr=this.data;
		if(this.filter.length>0){
			arr=this.filter;
		}
		var l = arr.length;
		var j = 0;
		if(filter_func && typeof(filter_func)==='function'){
			while (j < l) {
				var _data=arr[j];
				if(filter_func.call(this,_data,j)){
					break;
				}
				j++;
			}
		}else if(typeof(filter_func)==='number'){
			j=filter_func;
		}
		if(j>-1 && j<l){
			arr.splice(j,1);
		}
		this.filter=[];
		this.data=arr;
		this.draw();
	};
	this.update_row=function(filter_func){
		var arr=this.data;
		if(this.filter.length>0){
			arr=this.filter;
		}
		var l = arr.length;
		var j = 0;
		if(filter_func && typeof(filter_func)==='function'){
			while (j < l) {
				var _data=arr[j];
				if(filter_func.call(this,_data,j,arr)){
					break;
				}
				j++;
			}
		}
		this.filter=[];
		this.data=arr;
		this.draw();
	};
	this.find_row=function(filter_func){
		var arr=this.data;
		if(this.filter.length>0){
			arr=this.filter;
		}
		var l = arr.length;
		var j = 0;
		var index=-1;
		if(filter_func && typeof(filter_func)==='function'){
			while (j < l) {
				var _data=arr[j];
				if(filter_func.call(this,_data,j,arr)){
					index=j;
					break;
				}
				j++;
			}
		}
		return index;
	};
	this.add_row=function(_data,index){
		var arr=this.data;
		if(this.filter.length>0){
			arr=this.filter;
		}
		index=index===undefined?0:index;
		arr.splice(index,0,_data);
		this.filter=[];
		this.data=arr;
		this.draw();
		return arr.length-1;
	};
	this.calc_pages=function(){
		var numItems=this.data.length;
		if(!this.virtual){
			this.start_index=0;
			this.end_index =numItems;

			return;
		}
		this.trigger('before_calc_pages',[]);
		
		var scrollTop=this.scroller.scrollTop;
		var header_height=this.table_header.offsetHeight;
		var footer_height=this.table_footer.offsetHeight;
		//var clientHeight=this.div.clientHeight-(header_height+footer_height);
		var clientHeight=this.div.offsetHeight-(header_height+footer_height);
		this.scroller.style.height=(clientHeight)+'px';
		if(this.single_row_height===0 && numItems>0){
			var wh=25;
			//if(!this.dynamic_height){
				this.data[0].row_top=0;
				this.data[0].row_height=0;
				this.table_body.innerHTML=this.render_row(0);
				wh=this.table_body.childNodes[0].offsetHeight;
			//}
			this.single_row_height=wh;
		}
		var oldH = this.totalHeight;
		this.viewportH=clientHeight;
		this.virtualHeight = Math.max(this.single_row_height * numItems, clientHeight);
		if (this.virtualHeight < this.maxSupportedCssHeight) {
			// just one page
			this.totalHeight = this.pageHeight = this.virtualHeight;
			this.numPages = 1;
			this.cj = 0;
		} else {
			// break into pages
			this.totalHeight =this.maxSupportedCssHeight;// real scrollable height
			//this.pageHeight = this.totalHeight / 100;
			//this.pageHeight =(this.totalHeight-clientHeight) / this.single_row_height;
			this.pageHeight =this.totalHeight;
			this.numPages = Math.floor(this.virtualHeight / this.pageHeight);
			//this.cj = (this.virtualHeight - this.totalHeight) / (this.numPages - 1);//"jumpiness" coefficient
			this.cj = (this.virtualHeight - this.totalHeight) / this.numPages;//"jumpiness" coefficient
		}
		if (this.totalHeight !== oldH) {
			this.table_body.style.height=this.totalHeight+'px';
		}
		//this.start_index= Math.floor((scrollTop) / this.single_row_height);
		//this.end_index = Math.min(numItems,Math.ceil((scrollTop + clientHeight) / this.single_row_height));
		
		/* Working code
		var vScrollDist = Math.abs(scrollTop - this.last_scrollTop);
		
		// switch virtual pages if needed
		var oldScrollTopInRange = (scrollTop + this.offset <= this.virtualHeight - this.viewportH);
		
		if (scrollTop == 0) {
			//this.page = this.offset = 0;
		} else if (oldScrollTopInRange) {
			// maintain virtual position
			//scrollTo(scrollTop + offset);
		} else {
			// scroll to bottom
			//scrollTo(th - viewportH);
			//scrollTop=this.virtualHeight;//-this.viewportH;
		}
		 
		var oldOffset = this.offset;
		
		//if (vScrollDist < this.viewportH) {
		if (vScrollDist < 101) {
			scrollTop+=this.offset;
		 
			var prevScrollTop=scrollTop- this.offset;
			this.page = Math.min(this.numPages- 1, Math.floor(scrollTop / this.pageHeight));
			this.offset = Math.round(this.page * this.cj);
			var newScrollTop =scrollTop- this.offset;
			if (prevScrollTop != (newScrollTop)) {
				this.scroller.scrollTop=newScrollTop;
				scrollTop=newScrollTop;
				this.last_scrollTop=scrollTop;
			}
			scrollTop+=this.offset;
        
		} else {
			var oldOffset = this.offset;
			//this.page = Math.min(this.numPages - 1
			//, Math.floor(scrollTop * ((this.virtualHeight - this.viewportH) / (this.totalHeight - this.viewportH)) * (1 / this.pageHeight)));
			this.page = Math.min(this.numPages - 1
			, Math.floor(scrollTop * ((this.virtualHeight) / (this.totalHeight - this.viewportH)) * (1 / this.pageHeight)));
			this.offset = Math.round(this.page * this.cj);
			//scrollTop=this.offset+scrollTop+(this.cj*(this.numPages-this.page));
			scrollTop=this.offset+scrollTop;
			
		}
		
		this.start_index= Math.floor((scrollTop) / this.single_row_height);
		this.end_index = Math.min(numItems,Math.ceil((scrollTop + clientHeight) / this.single_row_height));
		
		*/
		
		//var sh=this.scroller.scrollHeight-this.scroller.offsetHeight;
		var sh=this.scroller.scrollHeight-this.scroller.clientHeight;
		var p=0;
			if(sh>0){
				p=scrollTop/sh*(this.virtualHeight);
			}
		this.page = Math.min(this.numPages- 1, Math.floor((p) / this.pageHeight));
		this.offset = Math.round(this.page * this.cj);
		
		this.start_index= Math.floor((scrollTop+this.offset) / this.single_row_height);
		this.end_index = Math.min(numItems,Math.ceil((scrollTop + this.offset + clientHeight) / this.single_row_height));
		/*
		if(!this.dynamic_height){
			this.visible_items=this.end_index-this.start_index;
			var hi=Math.ceil(this.visible_items/2);
			this.start_index-=hi;
			this.end_index+=hi;
			if(this.start_index<0){
				this.start_index=0;
			}
			if(this.end_index>numItems){
				this.end_index=numItems;
			}
		}
		*/
		if(this.dynamic_height){
			var scroll_diff=Math.abs(this.last_scrollTop-scrollTop);
			//if(scroll_diff>clientHeight){
				this.start_index-=1;
			//}
			if(this.start_index<0){
				this.start_index=0;
			}
			this.end_index=0;
			var top=this.start_index*this.single_row_height;
			var ch=0;
			var s=this.start_index;
			var e=s+(numItems-s);
			for(var j=s;j<e;j++){
				this.end_index=j+1;
				this.data[j].row_top=top;
				this.data[j].row_height=0;
				this.table_body.innerHTML=this.render_row(j);
				var wh=this.table_body.childNodes[0].offsetHeight;
				ch+=(wh-this.single_row_height);
				top+=wh;
				this.data[j].row_height=wh;
				if(top>(scrollTop+clientHeight)){
					break;
				}
			}
			var d=this.scroller.scrollHeight-(this.totalHeight+ch);
			
			if(d!==0){
				this.table_body.style.height=(this.totalHeight+ch)+'px';
			}
			if(d>0){
				this.last_ch=d;
			}else{
				this.last_ch=0;
			}
			//this.table_body.style.height=(numItems+ch)+'px';
			this.visible_items=this.end_index-this.start_index;
		}
	};
	this.update_body=function(){
		this.calc_pages();
		this.rows=[];
		this.render_body();
	};
	this.update_data=function(data){
		var _this=this;
		this.trigger('before_update_data',[]);
		this.totalHeight=0;
		this.single_row_height=0;
		this.show_preloader();
		if(data){
			this.data=data;
			this.filter=[];
		}
		this.prepare_data();
		//if(this.require_render_header){
		//	this.require_render_header=false;
			this.render_header();
		//}
		this.render_footer(false);
		this.update_body();
		
		setTimeout(function(){
			_this.hide_preloader();
		},300);
	};
	this.render_header=function(){
		this.sum_cols=0;
		this.maxw=0;
		this.all_cols_visible=true;
		if(this.data.length>0 ){//&& this.hCells.length!==this.cols.length){
			this.table_body.innerHTML=this.render_row(this.data.length-1,true);
			this.hCells=this.table_body.childNodes[0].querySelectorAll('td');
		}
		var header_html='';
		header_html+="<tr>";
		for(var i=0;i<this.cols.length;i++){
			var col=this.cols[i];
			
				var title=col.title;
				if(col.sortable){
					if(col.sort_order==='desc'){
						title+=this.sort_down_icon;
					}else if(col.sort_order==='asc'){
						title+=this.sort_up_icon;
					}else{
						title+=this.sort_icon;
					}
				}
				var wh=calc_str_wh(title,14,this.div);
			
				if(this.cols[i].width && wh.w<this.cols[i].width){
					wh.w=this.cols[i].width;
				}else{
					if(this.hCells.length>0){
						if(this.hCells[i].offsetWidth>wh.w){
							wh.w=this.hCells[i].offsetWidth;
						}
					}
				}
			if(col.visible===false){
				wh.w=0;
				title='';
			}
				this.cols[i].colw=wh.w;
				this.cols[i].colh=wh.h;

				var style='width:'+wh.w+'px;';
				header_html+='<th style="'+style+'" col_name="'+col.name+'" col_index="'+i+'" >';
				header_html+=title;
				header_html+='</th>';
			
				if(col.show_sum){
					this.sum_cols+=1;
				}
		}
		header_html+="</tr>";
		this.div.querySelector('.scroll_bar_holder').style.width=(this.scrollbarDimensions.width)+'px';
		this.table_header.style.width='calc(100% - '+(this.scrollbarDimensions.width)+'px)';
		//this.table_body.style.width='calc(100% - '+(this.scrollbarDimensions.width)+'px)';
		 
		this.table_header.style.display='';
		this.table_header.querySelector('thead').innerHTML=header_html;

		var cells=this.table_header.querySelector('thead').rows[0].cells;
		for(var i=0;i<this.cols.length;i++){
			//this.cols[i].colw2=cells[i].clientWidth;
			this.cols[i].colw2=cells[i].offsetWidth;
			this.maxw+=this.cols[i].colw2;
		}
		if((this.maxw+this.scrollbarDimensions.width)>(this.div.clientWidth+3) ){
			//if(this.responsive){
				this.all_cols_visible=false;
				this.table_header.style.display='none';
			//}
		}	 
		this.trigger('header',[this.table_header]);
	};
	this.format_cell=function(col,str){
		switch(col.type){
			case 'date':
				var _date=str;
				if(_date){
					_date=parse_date(_date,'YYYY-MM-DD HH:mm:ss');
					_date=format_date(_date,'DD-MM-YYYY');
				}else{
					_date='';
				}
				str=_date;
			break;
			case 'datetime':
				var _date=str;
				if(_date){
					_date=parse_date(_date,'YYYY-MM-DD HH:mm:ss');
					_date=format_date(_date,'DD-MM-YYYY hh:mm:ss A');
				}else{
					_date='';
				}
				str=_date;
			break;
			case 'num':
				str=col.format_num===false?str:round_num(str);
				//if(this.all_cols_visible){
				//	style+='text-align:right;';
				//}
			break;
		}
		return str;
	};
	this.render_cell=function(i,_data,j,internal){
		var html="";
		var col=this.cols[i];
		var str=_data[col.name] || '';
		var style='';
		if(this.all_cols_visible){
			//if(i!==this.cols.length-1){
			if(col.colw>0){
				style+='width:'+(col.colw)+'px;';
			}else{
				style+='width:auto;';
			}
		}
		if(col.name==='index'){
			str=j+1;
		}
			switch(col.type){
				case 'num':case 'int':
					if(this.all_cols_visible){
						style+='text-align:right;';
					}
				break;
				default:
					if(typeof(col.type)==='function'){
						var ret=col.type('render_cell',str,_data,i,j,col);
						if(ret && ret.style){
							style+=ret.style;
						}
						if(ret && ret.value_formatted){
							str=ret.value_formatted;
						}
					}
				break;
			}
			
		str=this.format_cell(col,str);
		
		if(col.on_render){
			str=col.on_render.call(this,col,_data,j,str,this.all_cols_visible,internal);
		}
		var col_visible='';
		if(col.visible===false){
			col_visible='display: none;';
		}
		if(this.all_cols_visible){
			html+='<td col_name="'+col.name+'" col_index="'+i+'" style="'+style+col_visible+'">';
				html+=str;
			html+="</td>";
		}else{
			html+='<tr style="'+col_visible+'">';
				html+='<td style="'+this.modal_col_title_style+'">';
				html+=col.title;
				html+=' : ';
				html+='</td>';
				html+='<td col_name="'+col.name+'" col_index="'+i+'" style="'+this.modal_col_data_style+'">'+str+'</td>';
			html+='</tr>';
		}
		return html;
	};
	this.render_row=function(j,internal){
		var html="";
		var _data=this.data[j];
		this.trigger('before_render_row',[_data,j]);
		var height=this.single_row_height;
		var style='';
		if(this.virtual){
			var top=(j*height)-this.offset;
			style+='position:absolute;';
			if(this.dynamic_height){
				top=this.data[j].row_top;
				height=this.data[j].row_height;
			}
			style+='top:'+top+'px;';
		}

			style+='width:100%;';
		if(height>0){
			style+='height:'+height+'px;';
		}else{
			style+='height:auto;';
		}
		html+='<div class="table_row grid_lines" row_index='+_data.row_index+' style="'+style+'">';
		var _html=null;
		if(!internal && this.options && this.options.on_render_row){
			_html=this.options.on_render_row.call(this,_data,j,this.all_cols_visible);
		}
		if(_html!==null && typeof(_html)==='string'){
			html+=_html;
		}else{
			style='';
				style+='table-layout:fixed;';
			if(height>0){
			}else{
				if(!this.virtual){
					style+='width:100%;';
				}else{
					style+='width:auto;';
				}
			}
			html+='<table class="no_grid_lines" style="'+style+'">';				
				if(this.all_cols_visible){
					html+='<tr class="main_row">';
				}
					for(var i=0;i<this.cols.length;i++){
						html+=this.render_cell(i,_data,j,internal);
					}
				if(this.all_cols_visible){
					html+="</tr>";
				}
			html+="</table>";
		}
		html+="</div>";	 
		return html;
	};
	this.render_body=function(){
		var _this=this;
		var html="";
		//$(this.table_body).addClass('skeleton-text skeleton-effect-wave');
		
		//for(var j=0;j<this.data.length;j++){
		for(var j=this.start_index;j<this.end_index;j++){
			this.data[j].row_index=j;
			html+=this.render_row(j);
		}
		this.table_body.innerHTML=html;
		//setTimeout(function(){
		//	$(_this.table_body).removeClass('skeleton-text').removeClass('skeleton-effect-wave');
		//},300);
		this.init_column_sort();
		
		this.rows=this.div.querySelectorAll('.table_row');
		for(var i=0;i<this.rows.length;i++){
			this.rows[i].onclick=function(e){
				var j=getInt(this.getAttribute('row_index'));
				var row=this;
				if(!_this.all_cols_visible){
					row=_this.show_detail(j);
				}
				var ret=_this.trigger('before_row_click',[j,row,e]);
				for(var i=0;i<ret.length;i++){
					if(ret[i]){
						j=ret[i].j || j;
						row=ret[i].row || row;
						e=ret[i].event || e;
					}
				}
				_this.trigger('row_click',[j,row,e]);
			};
		}
		this.trigger('draw',[]);
	};
	this.show_detail=function(j){
		var html='<div style="height:48px;"></div>'+this.render_row(j,true);
		this.modal.querySelector('.modal-content').innerHTML=html;
		this.modal.querySelector('.table_row').style.cssText='width:100%;';
		this.show_modal();
		var	row=this.modal.querySelector('.modal-content');
		this.trigger('draw',[]); 
		return row;
	};
	this.show_column_sort_popup=function(){
		this.modal_sort_open=true;
		var html='';
		html+='<h3>Sort List</h3>';
		html+='<table style="text-align:left;width: 100%;table-layout: auto;">';
		for(var i=0;i<this.cols.length;i++){
			var col=this.cols[i];
			if(!col.sortable){
				continue;
			}
			var title=col.title;
				if(col.sort_order==='desc'){
					title+=this.sort_down_icon;
				}else if(col.sort_order==='asc'){
					title+=this.sort_up_icon;
				}else{
					title+=this.sort_icon;
				}
			html+='<tr>';
			 
				html+='<th col_name="'+col.name+'" col_index="'+i+'" >';
				html+=title;
				html+='</th>';
			html+='</tr>';
		}
		html+='</table>';
		this.modal.querySelector('.modal-content').innerHTML=html;
		this.show_modal();
		
		this.init_column_sort();
	};
	this.show_modal=function(){
		var _this=this;
		this.modal.classList.add("open");
		var exits = this.modal.querySelectorAll(".modal-exit");
		for(var k=0;k<exits.length;k++){
			exits[k].onclick=function(){
				_this.hide_modal();
			};
		}
	};
	this.hide_modal=function(){
		this.modal_sort_open=false;
		this.modal.classList.remove("open");
	}
	this.is_modal_open=function(){
		return this.modal.classList.contains('open');
	};
	this.init_column_sort=function(){
		var _this=this;
		var sort_col=this.div.querySelectorAll('.sort_col');
		if(this.modal_sort_open && this.is_modal_open()){
			sort_col=this.modal.querySelectorAll('.sort_col');
		}
		for(var i=0;i<sort_col.length;i++){
			if(sort_col[i].parentNode.tagName==='TH'){
				sort_col[i].style.float='right';
			}
			//sort_col[i].style['font-size']='16px';
			sort_col[i].parentNode.onclick=function(){
				var i=getInt(this.getAttribute('col_index'));
				if(_this.cols[i].sort_order==='desc'){
					_this.cols[i].sort_order='';
				}else if(_this.cols[i].sort_order==='asc'){
					_this.cols[i].sort_order='desc';
				}else{
					_this.cols[i].sort_order='asc';
				}
				var col=_this.cols[i];
				if(col.sort_order==='desc'){
					this.innerHTML=col.title+_this.sort_down_icon;
				}else if(col.sort_order==='asc'){
					this.innerHTML=col.title+_this.sort_up_icon;
				}else{
					this.innerHTML=col.title+_this.sort_icon;
				}
				_this.update_data();
				
				
			};
			
		}

	};
	this.render_footer=function(user){
		var sum_cols=this.sum_cols;
		var footer_summary_title='Summary';
		var ret=this.trigger('before_footer',[this.table_footer,sum_cols]);
		var handled=false;
		for(var i=0;i<ret.length;i++){
			if(ret[i]){
				handled=true;
				sum_cols=ret[i].sum_cols || sum_cols;
				footer_summary_title=ret[i].footer_summary_title || footer_summary_title;
			}
		}
		var footer_html='';
			footer_html+="<tr><th>";
		if(sum_cols>0){
			footer_html+="<table>";
				footer_html+='<tr>';
					footer_html+='<th>'+footer_summary_title+'</th>';
					footer_html+="<th>";
						footer_html+="<table>";
						for(var i=0;i<this.cols.length;i++){
							var col=this.cols[i];
							if(col.show_sum){
								footer_html+='<tr>';
								footer_html+='<td style="padding:2px;height:23px;" >' + col.title+'</td>';
								str=col.sum;
								if(!isNaN(str)){
									if(col.name!=='index'){
										str=round_num(str);
									}
								}
								footer_html+='<td col_name="'+col.name+'" col_index="'+i+'" style="padding:2px;height:23px;text-align:right;" >' + str +'</td>';
								footer_html+="</tr>";
							}
						}
						footer_html+="</table>";
					footer_html+="</th>";
				footer_html+="</tr>";
			footer_html+="</table>";
			this.show_footer(false);
		}else{
			this.hide_footer(false);
		}
			footer_html+="</th></tr>";
		this.table_footer.querySelector('tfoot').innerHTML=footer_html;
		this.trigger('footer',[this.table_footer]);
		if(user!==false){
			this.trigger('draw',[]);
		}
	};
	this.hide_footer=function(b){
		this.table_footer.style.display='none';
		if(b!==false){
			this.update_body();
		}
		if(this.footer_timerID){
			clearTimeout(this.footer_timerID);
			this.footer_timerID=0;
		}
	};
	this.show_footer=function(b){
		this.table_footer.style.display='';
		if(b!==false){
			this.update_body();
		}
		if(this.footer_timerID){
			clearTimeout(this.footer_timerID);
			this.footer_timerID=0;
		}
		if(this.auto_hide_footer>0){
			var _this=this;
			this.footer_timerID=setTimeout(function(){
				_this.hide_footer();
			},this.auto_hide_footer);
		}
	};
	this.is_footer_hidden=function(){
		return this.table_footer.style.display==='none';
	};
	this.export_excel=function(){
		var tab_text="<table border='2px'><tr bgcolor='#87AFC6'>";
		var textRange; var i=0,j=0,str='';
		//tab = document.getElementById('headerTable'); // id of table
		//for(j = 0 ; j < tab.rows.length ; j++) {     
		//	tab_text=tab_text+tab.rows[j].innerHTML+"</tr>";
		//	//tab_text=tab_text+"</tr>";
		//}
			tab_text+='<tr>';
		for(i=0;i<this.cols.length;i++){
			tab_text+='<th>' + this.cols[i].title+'</th>';
		}
			tab_text+='</tr>';
		for(j=0;j<this.data.length;j++){
			tab_text+='<tr>';
			var _data=this.data[j];
			for(i=0;i<this.cols.length;i++){
				var col=this.cols[i];
				if(col.name==='index'){
					str=j+1;
				}else{
					str=(_data[col.name] || '');
				}
				
				str=this.format_cell(col,str);
				
				//if(col.on_render){
				//	str=col.on_render.call(this,col,_data,j,this.all_cols_visible);
				//}
				tab_text+='<td>' + str +'</td>';
			}
			tab_text+='</tr>';
		}
		//footer
			tab_text+='<tr>';
		for(i=0;i<this.cols.length;i++){
			tab_text+='<th>' + this.cols[i].sum+'</th>';
		}	
			tab_text+='</tr>';
		tab_text=tab_text+"</table>";
		//tab_text= tab_text.replace(/<A[^>]*>|<\/A>/g, "");//remove if u want links in your table
		//tab_text= tab_text.replace(/<img[^>]*>/gi,""); // remove if u want images in your table
		//tab_text= tab_text.replace(/<input[^>]*>|<\/input>/gi, ""); // removes input params

		var ua = window.navigator.userAgent;
		var msie = ua.indexOf("MSIE "); 
		if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)){      // If Internet Explorer
			txtArea1.document.open("txt/html","replace");
			txtArea1.document.write(tab_text);
			txtArea1.document.close();
			txtArea1.focus(); 
			sa=txtArea1.document.execCommand("SaveAs",true,"download.xls");
		}else {//other browser not tested on IE 11
			sa = window.open('data:application/vnd.ms-excel,' + encodeURIComponent(tab_text));  
		}
		return (sa);
	};
	this.draw=function(){
		this.update_data();
	};
	this.trigger=function(e,args){
		var ret=[];
		for(var i=0;i<this.events.length;i++){
			var event=this.events[i];
			if(event.e===e && event.f){
				ret.push(event.f.apply(this,args));
			}
		}
		return ret;
	};
	this.on=function(e,f){
		this.events.push({e:e,f:f});
	};
	this.off=function(e,f){
		for(var i=0;i<this.events.length;i++){
			var event=this.events[i];
			if(event.e===e && event.f===f){
				this.events.splice(i,1);
				break;
			}
		}
	};
	this.f_resize=function(){
		if (!this.resizing) {
			var _this=this;
			window.requestAnimationFrame(function(){
				var ret=_this.trigger('before_resize',[]);
				var b=true;
				for(var i=0;i<ret.length;i++){
					if(ret[i]===false){
						b=false;
						break;
					}
				}
				if(b){
					_this.require_render_header=true;
					_this.update_data();
				}
				_this.resizing=false;
				setTimeout(function(){
					_this.hide_preloader();
				},300);
			});
			this.resizing=true;
			this.show_preloader();
		}
	};
	this.show_preloader=function(){
		this.body_preloader.style.backgroundImage='url(preloader.gif)';
		this.body_preloader.style.display='';
	};
	this.hide_preloader=function(){
		this.body_preloader.style.display='none';
		this.body_preloader.style.backgroundImage='';
	};
	this.f_scroll=function(){
		if(!this.virtual){
			return;
		}
		if (!this.scrolling) {
			var _this=this;
			window.requestAnimationFrame(function(){
				if(_this.last_scrollTop!==_this.scroller.scrollTop){
					_this.update_body();
					_this.last_scrollTop=_this.scroller.scrollTop;
				}
				_this.scrolling=false;
				setTimeout(function(){
					_this.hide_preloader();
				},300);
			});
			this.scrolling=true;
			this.show_preloader();
		}
	};
	var b_f_resize=this.f_resize.bind(this);
	var b_f_scroll=this.f_scroll.bind(this);
	window.addEventListener('resize',b_f_resize,false);
	window.addEventListener('orientationchange',b_f_resize,false);
	this.scroller.addEventListener('scroll',b_f_scroll,false);
	this.destroy=function(){
		this.modal_div.parentNode.removeChild(this.modal_div);
		window.removeEventListener('resize',b_f_resize);
		window.removeEventListener('orientationchange',b_f_resize);
		this.scroller.removeEventListener('scroll',b_f_scroll);
	};
}

