var LF = String.fromCharCode.apply(null,[0x0A]);
var RESET_PRINTER = String.fromCharCode.apply(null,[0x1B, 0x40]);

var TEXT_ALIGN_LEFT = String.fromCharCode.apply(null,[0x1B, 0x61, 0x00]);
var TEXT_ALIGN_CENTER = String.fromCharCode.apply(null,[0x1B, 0x61, 0x01]);
var TEXT_ALIGN_RIGHT = String.fromCharCode.apply(null,[0x1B, 0x61, 0x02]);

var TEXT_WEIGHT_NORMAL = String.fromCharCode.apply(null,[0x1B, 0x45, 0x00]);
var TEXT_WEIGHT_BOLD = String.fromCharCode.apply(null,[0x1B, 0x45, 0x01]);

var LINE_SPACING_24 = String.fromCharCode.apply(null,[0x1b, 0x33, 0x18]);
var LINE_SPACING_30 = String.fromCharCode.apply(null,[0x1b, 0x33, 0x1e]);

var TEXT_FONT_A = String.fromCharCode.apply(null,[0x1B, 0x4D, 0x00]);
var TEXT_FONT_B = String.fromCharCode.apply(null,[0x1B, 0x4D, 0x01]);
var TEXT_FONT_C = String.fromCharCode.apply(null,[0x1B, 0x4D, 0x02]);
var TEXT_FONT_D = String.fromCharCode.apply(null,[0x1B, 0x4D, 0x03]);
var TEXT_FONT_E = String.fromCharCode.apply(null,[0x1B, 0x4D, 0x04]);

var TEXT_SIZE_NORMAL = String.fromCharCode.apply(null,[0x1D, 0x21, 0x00]);
var TEXT_SIZE_DOUBLE_HEIGHT = String.fromCharCode.apply(null,[0x1D, 0x21, 0x01]);
var TEXT_SIZE_DOUBLE_WIDTH = String.fromCharCode.apply(null,[0x1D, 0x21, 0x10]);
var TEXT_SIZE_BIG = String.fromCharCode.apply(null,[0x1D, 0x21, 0x11]);
var TEXT_SIZE_BIG_2 = String.fromCharCode.apply(null,[0x1D, 0x21, 0x22]);
var TEXT_SIZE_BIG_3 = String.fromCharCode.apply(null,[0x1D, 0x21, 0x33]);
var TEXT_SIZE_BIG_4 = String.fromCharCode.apply(null,[0x1D, 0x21, 0x44]);
var TEXT_SIZE_BIG_5 = String.fromCharCode.apply(null,[0x1D, 0x21, 0x55]);
var TEXT_SIZE_BIG_6 = String.fromCharCode.apply(null,[0x1D, 0x21, 0x66]);

var TEXT_UNDERLINE_OFF = String.fromCharCode.apply(null,[0x1B, 0x2D, 0x00]);
var TEXT_UNDERLINE_ON = String.fromCharCode.apply(null,[0x1B, 0x2D, 0x01]);
var TEXT_UNDERLINE_LARGE = String.fromCharCode.apply(null,[0x1B, 0x2D, 0x02]);

var TEXT_DOUBLE_STRIKE_OFF = String.fromCharCode.apply(null,[0x1B, 0x47, 0x00]);
var TEXT_DOUBLE_STRIKE_ON = String.fromCharCode.apply(null,[0x1B, 0x47, 0x01]);

var TEXT_COLOR_BLACK = String.fromCharCode.apply(null,[0x1B, 0x72, 0x00]);
var TEXT_COLOR_RED = String.fromCharCode.apply(null,[0x1B, 0x72, 0x01]);

var TEXT_COLOR_REVERSE_OFF = String.fromCharCode.apply(null,[0x1D, 0x42, 0x00]);
var TEXT_COLOR_REVERSE_ON = String.fromCharCode.apply(null,[0x1D, 0x42, 0x01]);


var BARCODE_TYPE_UPCA = 65;
var BARCODE_TYPE_UPCE = 66;
var BARCODE_TYPE_EAN13 = 67;
var BARCODE_TYPE_EAN8 = 68;
var BARCODE_TYPE_ITF = 70;
var BARCODE_TYPE_128 = 73;

var BARCODE_TEXT_POSITION_NONE = 0;
var BARCODE_TEXT_POSITION_ABOVE = 1;
var BARCODE_TEXT_POSITION_BELOW = 2;

var QRCODE_1 = 49;
var QRCODE_2 = 50;
var charset_windows_1252 = String.fromCharCode.apply(null,[0x1B, 0x74,6]);//windows-1252
var charsetEncoding=charset_windows_1252;
var useEscAsteriskCommand=false;

function bytesToHexadecimalString(bytes) {
	var imageHexString ='';
	for(var i=0;i<bytes.length;i++){
		aByte=bytes[i];
		var hexString =(aByte & 0xFF).toString(16);
		if (hexString.length=== 1) {
			hexString = "0" + hexString;
		}
		imageHexString+=hexString;
	}
	return imageHexString;
}
function hexadecimalStringToBytes(hexString) {
	var bytes = new Array(hexString.length/ 2);
	for (var i = 0; i < bytes.length; i++) {
		var pos = i * 2;
		bytes[i] = parseInt(hexString.substring(pos, pos + 2), 16);
	}
	return bytes;
}
function toUTF8Array(str) {
    var utf8 = [];
    for (var i=0; i < str.length; i++) {
        var charcode = str.charCodeAt(i);
        if (charcode < 0x80) utf8.push(charcode);
        else if (charcode < 0x800) {
            utf8.push(0xc0 | (charcode >> 6), 
                      0x80 | (charcode & 0x3f));
        }
        else if (charcode < 0xd800 || charcode >= 0xe000) {
            utf8.push(0xe0 | (charcode >> 12), 
                      0x80 | ((charcode>>6) & 0x3f), 
                      0x80 | (charcode & 0x3f));
        }
        // surrogate pair
        else {
            i++;
            // UTF-16 encodes 0x10000-0x10FFFF by
            // subtracting 0x10000 and splitting the
            // 20 bits of 0x0-0xFFFFF into two halves
            charcode = 0x10000 + (((charcode & 0x3ff)<<10)
                      | (str.charCodeAt(i) & 0x3ff));
            utf8.push(0xf0 | (charcode >>18), 
                      0x80 | ((charcode>>12) & 0x3f), 
                      0x80 | ((charcode>>6) & 0x3f), 
                      0x80 | (charcode & 0x3f));
        }
    }
    return utf8;
}
var encoder = new TextEncoder('UTF-8');
var toBytes = function(text){
  	return encoder.encode(text);
};
var toUTF8Bytes = function(text){
    var result = [];
    for (var i = 0; i < text.length; i += 1) {
        var hi = text.charCodeAt(i);
        if (hi < 0x0080) {
            // code point range: U+0000 - U+007F
            // bytes: 0xxxxxxx
            result.push(hi);
            continue;
        }
        if (hi < 0x0800) {
            // code point range: U+0080 - U+07FF
            // bytes: 110xxxxx 10xxxxxx
            result.push(0xC0 | hi >> 6,
                        0x80 | hi       & 0x3F);
            continue;
        }
        if (hi < 0xD800 || hi >= 0xE000 ) {
            // code point range: U+0800 - U+FFFF
            // bytes: 1110xxxx 10xxxxxx 10xxxxxx	
            result.push(0xE0 | hi >> 12,
                        0x80 | hi >>  6 & 0x3F,
                        0x80 | hi       & 0x3F);
            continue;
        }
        i += 1;
        if (i < text.length) {
            // surrogate pair
            var lo = text.charCodeAt(i);
            var code = 0x00010000 + (hi & 0x03FF) << 10 | lo & 0x03FF;
            // code point range: U+10000 - U+10FFFF
            // bytes: 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx
            result.push(0xF0 | code >> 18,
                        0x80 | code >> 12 & 0x3F,
                        0x80 | code >>  6 & 0x3F,
                        0x80 | code       & 0x3F);
        } else {
            break;
        }
    }
    return result;
};
var fill_text=function(fc,w){
	return new Array(w + 1).join(fc);
};
var make_text_short=function(str){
	if(str.search(/\b([A-Za-z])/g)>-1 && str.indexOf(' ')>-1){
		return str.match(/\b([A-Za-z])/g).join('');
	}
	//var str = "aaabbbccccabbbbcccccc";
	//console.log(str.replace(/(.)(?=.*\1)/g, "")); // "abc"	//"this, followed by something and this":
	//var str = "aabbccxccbbaa";
	//console.log(str.replace(/(.)(?=.*\1)/g, "")); // "xcba"	//this preserves the last occurrence of each character:
	var p=str.search(/[^\w\s]/gi);//special characters
		if(p>-1){
			str=str.substr(0,p);
		}
	str=str.replace(/ck/g,'k');
	str=str.replace(/th/g,'t');
	str=str.replace(/ll/g,'l');
	str=str.replace(/pp/g,'p');
	str=str.replace(/tt/g,'t');
	var fl=str.substr(0,1);
	var ll=str.substr(-1,1);
	if(str.length>4){
		//ll=ll.replace(/[e]/g,'');
		ll=ll.replace(/[aeiou]/g,'');
	}
	str=str.substr(1,str.length-2);
	//return fl+str.replace(/[aeiou]/g,'').replace(/(.)(?=.*\1)/g,'')+ll;
	return fl+str.replace(/[aeiou]/g,'').replace(/(.)(?=.*\2)/g,'')+ll;
};
var make_text_short2=function(str){
	var p=str.search(/[^\w\s]/gi);//special characters
		if(p>-1){
			str=str.substr(0,p);
		}
	str=str.replace(/[aeiou]/g,'').replace(/(.)(?=.*\1)/g,'');
	var fl=str.substr(0,1);
	var ll=str.substr(-1,1);
	str=str.substr(1,str.length-2);
	var ml=str;//.substr(0,1);
	 
	return (fl+ml+ll).toUpperCase();
};

var make_text_code=function(str){
	var result = "",hex;
	for (i=0; i<str.length; i++) {
		hex = str.charCodeAt(i).toString(16);
		result += ("00"+hex).slice(-2).toUpperCase();
	}
	return result;
};
var text_from_code=function(str){
	var result = "",chr;
	for (i=0; i<str.length;i+=2) {
		chr =String.fromCharCode(parseInt(str.substr(i,2),16));
		result +=chr;
	}
	return result;
};
var left_text=function(str,w,fc){
	var fill=fill_text(fc,w);
	str=str+'';
	var r=Math.max(0,(w-(str.length)));
	return str.substr(0,w) + fill.substr(0,r);
};
var center_text=function(str,w,fc){
	var fill=fill_text(fc,w);
	str=str+'';
	var h=Math.max(0,Math.floor((w-str.length)/2));
	var r=Math.max(0,(w-(str.length+h)));
	return fill.substr(0,r) + str.substr(0,w) + fill.substr(0,h);
};
var right_text=function(str,w,fc){
	var fill=fill_text(fc,w);
	str=str+'';
	var r=Math.max(0,(w-(str.length)));
	return fill.substr(0,r) + str.substr(0,w);
};
var column_text=function(cols,w,fc){
	var col_w=Math.floor(w/cols.length);
	var r=w % col_w;
	var ret='';
	var fill=fill_text(fc,w);
	for(var c=0;c<cols.length;c++){
		var cw=c===0?col_w+r:col_w;	
		var col=cols[c];
			if(col.w){
				cw=col.w;
			}
		var str=col.t;
		switch(col.a){
			case 'l':
				str=left_text(str,cw,fc);
			break;
			case 'c':
				str=center_text(str,cw,fc);
			break;
			case 'r':
				str=right_text(str,cw,fc);
			break;
		}
		ret+=str;
	}
	return ret;
};

function mmToPx(printerDpi,mmSize){
	var INCH_TO_MM = 25.4;
	return Math.floor(mmSize*printerDpi/INCH_TO_MM);
}

var i_b_a_canvas=document.createElement('canvas');
function bitmapToPrintBytes(bitmap,printerDpi,printerWidthMM,b_gray) {
	var isSizeEdit = false;
	var printerWidthPx=mmToPx(printerDpi,printerWidthMM);
	var bitmapWidth = bitmap.width,
			bitmapHeight = bitmap.height,
			maxWidth = printerWidthPx,
			maxHeight = 256;
	if (bitmapWidth > maxWidth) {
		bitmapHeight = Math.floor(bitmapHeight*maxWidth/bitmapWidth);
		bitmapWidth = maxWidth;
		isSizeEdit = true;
	}
	if (bitmapHeight > maxHeight) {
		bitmapWidth = Math.floor(bitmapWidth*maxHeight/bitmapHeight);
		bitmapHeight = maxHeight;
		isSizeEdit = true;
	}
	if (isSizeEdit) {
	//	bitmap = Bitmap.createScaledBitmap(bitmap, bitmapWidth, bitmapHeight, true);
	}
	return bitmapToBytes(bitmap,bitmapWidth, bitmapHeight,b_gray);
}
function bitmapToBytes(bitmap,bitmapWidth, bitmapHeight,b_gray) {
	var bytesByLine =Math.ceil(bitmapWidth/8);
	var imageBytes = initGSv0Command(bytesByLine, bitmapHeight);
	var i = 8,
		greyscaleCoefficientInit = 0,
		gradientStep = 6;
	var
		colorLevelStep = 765.0 / (15 * gradientStep + gradientStep - 1);
	i_b_a_canvas.width=bitmapWidth;
	i_b_a_canvas.height=bitmapHeight;
	var context = i_b_a_canvas.getContext('2d',{ willReadFrequently: true});
	context.drawImage(bitmap, 0, 0,bitmapWidth,bitmapHeight);
	//var data = context.getImageData(0, 0,bitmapWidth,bitmapHeight).data;
	for (var posY = 0; posY < bitmapHeight; posY++) {
		var greyscaleCoefficient = greyscaleCoefficientInit,
			greyscaleLine = posY % gradientStep;
		for (var j = 0; j < bitmapWidth; j += 8) {
			var b = 0;
			for (var k = 0; k < 8; k++) {
				var posX = j + k;
				if (posX < bitmapWidth) {
					//var color = bitmap.getPixel(posX, posY),
					//	red = (color >> 16) & 255,
					//	green = (color >> 8) & 255,
					//	blue = color & 255;
			
					var p = context.getImageData(posX,posY, 1, 1).data,
						red =p[0],
						green =p[1],
						blue =p[2];
					if(b_gray){
						red=green=blue=(red+green+blue)/3;
					}
					if ((red + green + blue) < ((greyscaleCoefficient * gradientStep + greyscaleLine) * colorLevelStep)) {
						b |= 1 << (7 - k);
					}
					greyscaleCoefficient += 5;
					if (greyscaleCoefficient > 15) {
						greyscaleCoefficient -= 16;
					}
				}
			}
			imageBytes[i++] =b;
		}
		greyscaleCoefficientInit += 2;
		if (greyscaleCoefficientInit > 15) {
			greyscaleCoefficientInit = 0;
		}
	}
	return imageBytes;
}
function canvasToPrintBytes(canvas,width,height,printerDpi,printerWidthMM,b_gray) {
	var isSizeEdit = false;
	var printerWidthPx=mmToPx(printerDpi,printerWidthMM);
	var bitmapWidth = width,
			bitmapHeight = height,
			maxWidth = printerWidthPx,
			maxHeight = 256;
	if (bitmapWidth > maxWidth) {
		bitmapHeight = Math.floor(bitmapHeight*maxWidth/bitmapWidth);
		bitmapWidth = maxWidth;
		isSizeEdit = true;
	}
	if (bitmapHeight > maxHeight) {
		bitmapWidth = Math.floor(bitmapWidth*maxHeight/bitmapHeight);
		bitmapHeight = maxHeight;
		isSizeEdit = true;
	}
	return canvasToBytes(canvas,bitmapWidth, bitmapHeight,b_gray);
}

function canvasToBytes(canvas,bitmapWidth, bitmapHeight,b_gray) {
	var bytesByLine =Math.ceil(bitmapWidth/8);
	var imageBytes = initGSv0Command(bytesByLine, bitmapHeight);
	var i = 8,
		greyscaleCoefficientInit = 0,
		gradientStep = 6;
	var
		colorLevelStep = 765.0 / (15 * gradientStep + gradientStep - 1);
	 
	var context = canvas.getContext('2d');
	//var data = context.getImageData(0, 0,bitmapWidth,bitmapHeight).data;
	for (var posY = 0; posY < bitmapHeight; posY++) {
		var greyscaleCoefficient = greyscaleCoefficientInit,
			greyscaleLine = posY % gradientStep;
		for (var j = 0; j < bitmapWidth; j += 8) {
			var b = 0;
			for (var k = 0; k < 8; k++) {
				var posX = j + k;
				if (posX < bitmapWidth) {
					
					var p = context.getImageData(posX,posY, 1, 1).data,
						red =p[0],
						green =p[1],
						blue =p[2];
					if(b_gray){
						red=green=blue=(red+green+blue)/3;
					}
					if ((red + green + blue) < ((greyscaleCoefficient * gradientStep + greyscaleLine) * colorLevelStep)) {
						b |= 1 << (7 - k);
					}
					greyscaleCoefficient += 5;
					if (greyscaleCoefficient > 15) {
						greyscaleCoefficient -= 16;
					}
				}
			}
			imageBytes[i++] =b;
		}
		greyscaleCoefficientInit += 2;
		if (greyscaleCoefficientInit > 15) {
			greyscaleCoefficientInit = 0;
		}
	}
	return imageBytes;
}

function initGSv0Command(bytesByLine,bitmapHeight) {
	var
		xH = Math.floor(bytesByLine / 256),
		xL = bytesByLine - (xH * 256),
		yH = Math.floor(bitmapHeight / 256),
		yL = bitmapHeight - (yH * 256);

	var imageBytes =new Array(8 + bytesByLine * bitmapHeight);
	imageBytes[0] = 0x1D;
	imageBytes[1] = 0x76;
	imageBytes[2] = 0x30;
	imageBytes[3] = 0x00;
	imageBytes[4] = Math.floor(xL);
	imageBytes[5] = Math.floor(xH);
	imageBytes[6] = Math.floor(yL);
	imageBytes[7] = Math.floor(yH);
	return imageBytes;
}

function convertGSv0ToEscAsterisk(bytes) {
	var
		xL = bytes[4] & 0xFF,
		xH = bytes[5] & 0xFF,
		yL = bytes[6] & 0xFF,
		yH = bytes[7] & 0xFF,
		bytesByLine = xH * 256 + xL,
		dotsByLine = bytesByLine * 8,
		nH = Math.floor(dotsByLine / 256),
		nL = dotsByLine % 256,
		imageHeight = yH * 256 + yL,
		imageLineHeightCount = Math.ceil(imageHeight / 24.0),
		imageBytesSize = 6 + bytesByLine * 24;

	var returnedBytes = new Array(imageLineHeightCount + 2);
	returnedBytes[0] = LINE_SPACING_24;
	for (var i = 0; i < imageLineHeightCount; ++i) {
		var pxBaseRow = i * 24;
		var imageBytes = new Array(imageBytesSize);
		imageBytes[0] = 0x1B;
		imageBytes[1] = 0x2A;
		imageBytes[2] = 0x21;
		imageBytes[3] = nL;
		imageBytes[4] = nH;
		for (var j = 5; j < imageBytes.length; ++j) {
			var
				imgByte = j - 5,
				byteRow = imgByte % 3,
				pxColumn = Math.floor(imgByte / 3),
				bitColumn = 1 << (7 - pxColumn % 8),
				pxRow = pxBaseRow + byteRow * 8;
			for (var k = 0; k < 8; ++k) {
				var indexBytes = bytesByLine * (pxRow + k) + pxColumn / 8 + 8;

				if (indexBytes >= bytes.length) {
					break;
				}

				var isBlack = (bytes[indexBytes] & bitColumn) == bitColumn;
				if (isBlack) {
					imageBytes[j] |= 1 << 7 - k;
				}
			}
		}
		imageBytes[imageBytes.length - 1] = LF;
		returnedBytes[i + 1] = imageBytes;
	}
	returnedBytes[returnedBytes.length - 1] = LINE_SPACING_30;
	return returnedBytes;
}
 
    
/**
 * Reset printers parameters.
 */
function bt_printer_reset() {
	return RESET_PRINTER;
}
  
var currentTextSize = "";
var currentTextColor = "";
var currentTextReverseColor = "";
var currentTextBold = "";
var currentTextUnderline = "";
var currentTextDoubleStrike = "";

/**
 * Print text with the connected printer.
 *
 * @param text             Text to be printed
 * @param textSize         Set the text size. Use EscPosPrinterCommands.TEXT_SIZE_... constants
 * @param textColor        Set the text color. Use EscPosPrinterCommands.TEXT_COLOR_... constants
 * @param textReverseColor Set the background and text color. Use EscPosPrinterCommands.TEXT_COLOR_REVERSE_... constants
 * @param textBold         Set the text weight. Use EscPosPrinterCommands.TEXT_WEIGHT_... constants
 * @param textUnderline    Set the underlining of the text. Use EscPosPrinterCommands.TEXT_UNDERLINE_... constants
 * @param textDoubleStrike Set the double strike of the text. Use EscPosPrinterCommands.TEXT_DOUBLE_STRIKE_... constants
 * @return Fluent interface
 */
function bt_print_text(text,textSize,textColor,textReverseColor,textBold,textUnderline,textDoubleStrike){
	if (textSize === undefined) {
		textSize = TEXT_SIZE_NORMAL;
	}
	if (textColor ===undefined) {
		textColor = TEXT_COLOR_BLACK;
	}
	if (textReverseColor ===undefined) {
		textReverseColor = TEXT_COLOR_REVERSE_OFF;
	}
	if (textBold ===undefined) {
		textBold = TEXT_WEIGHT_NORMAL;
	}
	if (textUnderline ===undefined) {
		textUnderline = TEXT_UNDERLINE_OFF;
	}
	if (textDoubleStrike ===undefined) {
		textDoubleStrike = TEXT_DOUBLE_STRIKE_OFF;
	}
	//blutooth_device_write_bytes(  bytesToHexadecimalString(toUTF8Bytes(charsetEncoding)));
	blutooth_device_write(charsetEncoding,"");
	if (currentTextSize!=textSize) {
		blutooth_device_write(textSize,"");
		currentTextSize = textSize;
	}
	if (currentTextDoubleStrike!=textDoubleStrike) {
		blutooth_device_write(textDoubleStrike,"");
		currentTextDoubleStrike = textDoubleStrike;
	}
	if (currentTextUnderline!=textUnderline) {
		blutooth_device_write(textUnderline,"");
		currentTextUnderline = textUnderline;
	}
	if (currentTextBold!=textBold) {
		blutooth_device_write(textBold,"");
		currentTextBold = textBold;
	}
	if (currentTextColor!=textColor) {
		blutooth_device_write(textColor,"");
		currentTextColor = textColor;
	}
	if (currentTextReverseColor!=textReverseColor) {
		blutooth_device_write(textReverseColor);
		currentTextReverseColor = textReverseColor;
	}
	blutooth_device_write(text,"");
}
function bt_print_new_line(w){
	w=w===undefined?0:w;
	blutooth_device_write(LF,"");
	return blutooth_device_send(w);
}
/**
 * Feed the paper
 *
 * @param dots Number of dots to feed (0 <= dots <= 255)
 * @return Fluent interface
 */
function bt_print_feed_paper(dots){
	if (dots > 0) {
		blutooth_device_write(String.fromCharCode.apply(null,[0x1B, 0x4A,dots]),"");
		blutooth_device_send(dots);
	}
}
/**
 * Cut the paper
 *
 * @return Fluent interface
 */
function bt_print_cut_paper(){
	blutooth_device_write(String.fromCharCode.apply(null,[0x1D, 0x56, 0x01]),"");
	blutooth_device_send(100);
}
/**
 * Open the cash box
 *
 * @return Fluent interface
 */
function bt_print_open_cash_box(){
	//27 112 0 60 255
	blutooth_device_write(String.fromCharCode.apply(null,[0x1B, 0x70, 0x00, 0x3C,0xFF]),"");
	blutooth_device_send(100);
	
	//27  112  0 25 250
	//blutooth_device_write(String.fromCharCode.apply(null,[27,112,0,25,250]),"");
	//blutooth_device_send(100);
	/*
	ASCII : ESC p m t1 t2
	Decimal: 27 112 0 20 80

	m = 0 for the 1st drawer
	m = 1 for the 2nd drawer
	*/
	//blutooth_device_write(String.fromCharCode.apply(null,[27,112,0,20,80]),"");
	//blutooth_device_send(100);

}
function bt_print_init(){
	blutooth_device_write(RESET_PRINTER, "");
	blutooth_device_write(charset_windows_1252, "");
	blutooth_device_write(TEXT_COLOR_BLACK, "");
	blutooth_device_write(TEXT_COLOR_REVERSE_OFF, "");
	blutooth_device_write(TEXT_WEIGHT_NORMAL, "");
	blutooth_device_write(TEXT_UNDERLINE_OFF, "");
	blutooth_device_write(TEXT_DOUBLE_STRIKE_OFF, "");
	blutooth_device_write(TEXT_ALIGN_LEFT, "");
	blutooth_device_write(TEXT_SIZE_NORMAL, "");
}
function printAllCharsetsEncodingCharacters() {
	for (var charsetId = 0; charsetId < 256; ++charsetId) {
		printCharsetEncodingCharacters(charsetId);
	}
}
function printCharsetEncodingCharacters(charsetId) {
	blutooth_device_write(String.fromCharCode.apply(null,[0x1B, 0x74,charsetId]),"");
	blutooth_device_write(TEXT_SIZE_NORMAL,"");
	blutooth_device_write(TEXT_COLOR_BLACK,"");
	blutooth_device_write(TEXT_COLOR_REVERSE_OFF,"");
	blutooth_device_write(TEXT_WEIGHT_NORMAL,"");
	blutooth_device_write(TEXT_UNDERLINE_OFF,"");
	blutooth_device_write(TEXT_DOUBLE_STRIKE_OFF,"");
	blutooth_device_write(":::: Charset n°" + charsetId + " : ","");
	var bytes=new Array(256);
		for(var i=0;i<256;i++){
			bytes[i]=i;
		}
	blutooth_device_write(String.fromCharCode.apply(null,bytes),"");
	blutooth_device_write(LF+LF+LF+LF);
	blutooth_device_send(0);
}
/*
	a=[1,2,3,4,3,2,1]; //source array  
    b=[5,6,7,8,7,6,5]; //destination array
	srcPos=1;  
	destPos=2;  
	length=4;
	arraycopy(a, srcPos, b, destPos, length); 
	Destination array after use of arraycopy()
	5623435
*/
function arraycopy(src,srcPos,dest,destPos,length){
	for(var i=srcPos;i<srcPos+length;i++){
		dest[destPos+(i-srcPos)]=src[i];
	}
}
function bt_write_image(hex,printerDpi,printerWidthMM,textAlign,useEscAsteriskCommand){
	var image=hexadecimalStringToBytes(hex);
	var printingWidthPx = mmToPx(printerDpi,printerWidthMM);//203,48
	var printerWidthPx = printingWidthPx + (printingWidthPx % 8);
	var printerCharSizeWidthPx = printingWidthPx / 32;//this.printerNbrCharactersPerLine;
	var
			byteWidth = (Math.floor(image[4] & 0xFF)) + (Math.floor(image[5] & 0xFF)) * 256,
			width = byteWidth * 8,
			height = (Math.floor(image[6] & 0xFF)) + (Math.floor(image[7] & 0xFF)) * 256,
			nbrByteDiff = Math.floor((printerWidthPx - width) / 8),
			nbrWhiteByteToInsert = 0;
	switch (textAlign) {
		case "C":
			nbrWhiteByteToInsert = Math.round(nbrByteDiff / 2);
		break;
		case "R":
			nbrWhiteByteToInsert = nbrByteDiff;
		break;
	}

	if (nbrWhiteByteToInsert > 0) {
		var newByteWidth = byteWidth + nbrWhiteByteToInsert;
		var newImage = initGSv0Command(newByteWidth, height);
		var imageLength=image.length;
		var newImageLength=newImage.length;
		for (var i = 0; i < height; i++) {
			var srcPos=(byteWidth * i + 8);
			var destPos= (newByteWidth * i + nbrWhiteByteToInsert + 8);
			if(srcPos+1>imageLength){
				break;
			}
			arraycopy(image,srcPos , newImage,destPos, byteWidth);
		}
		image = newImage;
	}
	blutooth_device_write_bytes(bytesToHexadecimalString(image));
	blutooth_device_send(0);
}
function bt_write_QRCode(qrCodeType,text,size)   {
	if (size < 1) {
		size = 1;
	} else if (size > 16) {
		size = 16;
	}
	var textBytes =toUTF8Array(text);
	var
			commandLength = textBytes.length + 3,
			pL = commandLength % 256,
			pH = commandLength / 256;

	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x28, 0x6B, 0x04, 0x00, 0x31, 0x41, qrCodeType, 0x00]));
	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x28, 0x6B, 0x03, 0x00, 0x31, 0x43,size]));
	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x28, 0x6B, 0x03, 0x00, 0x31, 0x45, 0x30]));

	var qrCodeCommand = new Array(textBytes.length + 8);
	arraycopy([0x1D, 0x28, 0x6B,pL,pH, 0x31, 0x50, 0x30], 0, qrCodeCommand, 0, 8);
	arraycopy(textBytes, 0, qrCodeCommand, 8, textBytes.length);
	blutooth_device_write_bytes(bytesToHexadecimalString(qrCodeCommand));
	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x28, 0x6B, 0x03, 0x00, 0x31, 0x51, 0x30]));
	blutooth_device_send(0);
}
function bt_write_Barcode(code,barcodeLength,BarcodeType,TextPosition,ColWidth,Height) {
	var barcodeCommand = new Array(barcodeLength + 4);
	arraycopy([0x1D, 0x6B,BarcodeType,barcodeLength], 0, barcodeCommand, 0, 4);

	for (var i = 0; i < barcodeLength; i++) {
		barcodeCommand[i + 4] = code.charCodeAt(i);
	}

	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x48,TextPosition]));
	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x77,ColWidth]));
	blutooth_device_write_bytes(bytesToHexadecimalString([0x1D, 0x68,Height]));
	blutooth_device_write_bytes(bytesToHexadecimalString(barcodeCommand));
	blutooth_device_send(0);
}

var temp_canvas = document.createElement("canvas");
var temp_ctx = temp_canvas.getContext("2d");
function getMetrics(ctx,text) {
var m = ctx.measureText(text);
return {
  width:
	Math.abs(m.actualBoundingBoxLeft) + Math.abs(m.actualBoundingBoxRight),
  height:
	Math.abs(m.fontBoundingBoxAscent) + Math.abs(m.fontBoundingBoxDescent),
  height2:
	Math.abs(m.actualBoundingBoxAscent) + Math.abs(m.actualBoundingBoxDescent),	
};
}
function cropImageFromCanvas(ctx) {
  var canvas = ctx.canvas, 
    w = canvas.width, h = canvas.height,
    pix = {x:[], y:[]},
    imageData = ctx.getImageData(0,0,canvas.width,canvas.height),
    x, y, index;
  
  for (y = 0; y < h; y++) {
    for (x = 0; x < w; x++) {
      index = (y * w + x) * 4;
      //if (imageData.data[index+3] > 0) {
	  if(imageData.data[index] != 255 && imageData.data[index+1] != 255 && imageData.data[index+2] != 255){
        pix.x.push(x);
        pix.y.push(y);
      } 
    }
  }
  pix.x.sort(function(a,b){return a-b});
  pix.y.sort(function(a,b){return a-b});
  var n = pix.x.length-1;
  
  w = 1 + pix.x[n] - pix.x[0];
  h = 1 + pix.y[n] - pix.y[0];
  var cut = ctx.getImageData(pix.x[0], pix.y[0], w, h);

  canvas.width = w;
  canvas.height = h;
  ctx.putImageData(cut, 0, 0);
        
  return canvas.toDataURL();
}
function unicode_get_img(text,fontName,fontHeight,fontStyle){
	var lineHeight = 1.2;
	//temp_ctx.font = "bold 30px Arial";
	temp_ctx.font =fontStyle+" " +(fontHeight)+ "px "+fontName;
	//var w=temp_ctx.measureText(str).width;//;
	var metrics = getMetrics(temp_ctx,text);
    var rowHeight = metrics.height + fontHeight * lineHeight;
    var w=metrics.width*1.2;
	var h=metrics.height*1.2;//metrics.height2* lineHeight;//rowHeight;//fontHeight
	
	temp_canvas.width=w;
	temp_canvas.height=h;
	temp_ctx.fillStyle ='white';//
	temp_ctx.fillRect(0, 0, temp_canvas.width, temp_canvas.height);
	//font will be reset after canvas resized so need to set font again
	temp_ctx.font =fontStyle+" " +(fontHeight)+ "px "+fontName;
	temp_ctx.fillStyle ='black';//
	//temp_ctx.fillText(text,0,fontHeight);
	//temp_ctx.fillText(text,0,(h)-(fontHeight/4));
	temp_ctx.textBaseline = 'middle';
	temp_ctx.textAlign = 'center';
	temp_ctx.fillText(text,w/2,h/2);
	
	//return temp_canvas.toDataURL( 'image/jpeg',1);
	return cropImageFromCanvas(temp_ctx);
}
//unicode_get_img("മലയാളം","Arial",30,"bold");



/*
https://hackernoon.com/how-to-print-labels-with-tspl-and-javascript

Label printers can support programming languages like TSPL, ZPL, EPL, and so on. Today we are going to overview the TSPL language. We can build labels using TSPL commands like TEXT, BARCODE and QRCODE. For instance, if we want to print a label with a text and barcode, we use these commands with their properties like position or size, and send these commands to the label printer over Bluetooth or Serial connection.

On the left side, you can see the TSPL commands and the printed label on the right side. You can find all the available commands here, but let’s look at some of them to understand how to use the TSPL.

Coordinates and size in dots
Whether it is a TEXT, BARCODE or BITMAP, generally, the coordinates and size are in dots. The number of dots per inch depends on the printer's DPI.

For instance, if the printer is
203 DPI → means there are 203 dots in one inch, or there are 8 dots in 1 mm.
300 DPI → means there are 300 dots in one inch, or there are 11.8 dots in 1 mm.

Size and gap of the label
We need to tell the printer the size of the label like this:

SIZE 4,1

Here we said that size of the label is 4x1 inches.


We can also set it in a metric system (mm):

SIZE 50 mm,25 mm


We can set the gap which is the space between labels (GAP m,n).

GAP 0,0

Here the gap is zero inches which means it is a continuous label.

Text
We can use TEXT command to print a text on the label. We can give the position, font size, rotation, and so on:

TEXT x,y,“font”,rotation,x-multiplication,y-multiplication,[alignment,] “content”

Parameter

Description

x, y

x and y-coordinate

font

Generally, we can set 1-8 (1-small, 2-bigger… 8-biggest)

rotation

0, 90, 180, 270 in clockwise direction

x and y-multiplication

Scale factor 1-10

alignment

1-left, 2-center, 3-right (optional)

content

Text content


Barcode
We can add a barcode to the label with the BARCODE command:

BARCODE X,Y,”code type”,height,human-readable,rotation,narrow,wide,[alignment,]”content”


Parameter

Description

x, y

x and y-coordinate

code type

128, EAN128, EAN13…

height

Height in dots

human-readable

0 - barcode value (text) is not visible
1 - text is left-aligned
2 - center-aligned
3 - right-aligned

rotation

0, 90, 180, 270 in clockwise direction

narrow

Width of the narrow element in dots

wide

Width of the wide element in dots

alignment

1-left, 2-center, 3-right (optional)

content

Content of barcode


Sample commands:

TEXT 10,10, "2",0,1,1, "Human readable alignment"
BARCODE 10,50, "128",100,1,0,2,2,"left"
BARCODE 310,50, "128",100,2,0,2,2,"center"
BARCODE 610,50, "128",100,3,0,2,2,"right"


PRINT and END commands
After building the label we need to tell the printer that the label is ready to print. We use PRINT m[,n] command to do this:

Commands

Description

SIZE 50 mm,25 mm
CLS
TEXT 10,10, "2",0,1,1, "Text 1"
PRINT 1

CLS
TEXT 10,10, "2",0,1,1, "Text 2"
PRINT 2
END

- Set the size of the label
- Clear the buffer
- Add text
- Print the buffer once

- Clear the buffer
- Add text
- Print the buffer two times
- End of program


It prints three labels; one label with “Text 1“ and two labels with “Text 2“.


We add END command at the end, to tell the printer that we’ve finished printing. Without this command, the printer may not print the last image in the buffer.

BITMAP X,Y,width,height,mode,bitmap data…
Parameter Description
X Specify the x-coordinate
Y Specify the y-coordinate
width Image width (in bytes)
height Image height (in dots)
mode Graphic modes listed below:
0: OVERWRITE
1: OR
2: XOR
bitmap data Bitmap data

Number(255).toString(2)
'11111111'
parseInt('11111111', 2);
255


var canvas = document.createElement("canvas");
var ctx = canvas.getContext("2d");canvas.width=100;
canvas.height=100;ctx.fillStyle ='white';
ctx.fillRect(0, 0, canvas.width, canvas.height);
ctx.fillStyle ='black';
ctx.font='30px sans-serif';
ctx.fillText("test",50,50);

canvas.toDataURL( 'image/jpeg',1);

'Convert RGB to LONG:
LONG = B * 65536 + G * 256 + R.
'Convert LONG to RGB:
B = LONG \ 65536.
G = (LONG - B * 65536) \ 256.
R = LONG - B * 65536 - G * 256.

color=(r << 16) + (g << 8) + (b);
var components = {
    r: (c & 0xff0000) >> 16, 
    g: (c & 0x00ff00) >> 8, 
    b: (c & 0x0000ff)
};

mm = ( pixels * 25.4 ) / DPI(96, 203 or 300)
( 8 * 25.4 ) / 96 = 2.116mm. ( 8pixel)
(2.1166666666666667/25.4)*96=8px

60,80 in dots*(DPI==203?8:10)=mm

var wpx=((60/8)/25.4)*203;
var hpx=((80/8)/25.4)*203;

var s='ÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿ ÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿàÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿø ÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿü ÿÿÿøÿÿÿÿÿÿÿÿÿÿÿÿÿÿàÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿð ÿÿÿÿÿÿÿÿÿÿÿûÿÿÿÿà ÿÿÀ ÿÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿà ÿÿÿÿÿÿÿÿÿÿÿãÿÿÿÿ€ ÿÿ€ ÿÿÿÿÿÿÿÿÿüÿÿÀÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿÀ ÿÿÿÿÿÿÿÿÿÿÿÃÿÿÿÿ  ÿþ  ÿÿÿÿÿÿÿÿÿøÿÿÀÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿÀ ÿÿÿÿÿÿÿÿÿÿÿÿÿÿþ  ÿü  ÿÿÿÿÿÿÿÿÿàÿÿ€ ÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿÀ ÿÿÿÿÿÿÿÿÿÿüÿÿÿü   ÿü  ÿÿÿÿÿÿÿÿÿ€ÿÿ€ ÿÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿ€ßÿÿÿÿÿÿÿÿÿÿøÿÿÿü   ÿø  ÿÿÿÿÿÿÿÿÿ ÿÿ  ÿÿÿÿÿ€ÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿø   ð  ÿÿÿÿÿÿÿÿþ ÿÿ  ÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿø x ðàÿÿÿÿÿÿÿÿþ ÿÿ  ÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿðþ ?àðÿÿÿÿÿÿÿÿþ ÿþ  ?ÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿðþ ?àøÿÿÿÿÿÿÿÿþ ÿþ  ?ÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿðÿ ?àüÿÿÿÿÿÿÿÿþ ÿü €ÿÿÿÿÿÿÿÿÿÿÿÿÀÿÿÿ€ÿÿÿÿÿÿÿÿÿÿÿðÿÿÿðÿ ?Àü ÿÿÿÿÿÿÿÿþ ÿü €ÿÿÿø?ÿÿÿðÿÿÀÿÿÿ€ÿÿÀÿÿÿÿÀ?ÿðÿÿÿðÿ ?Àü ÿÿÿÿÿøÿþ ÿü €ÿü à€ÿ€ ?ÿÀÿÿð  ?þ ÿÿ€ þ  ÿÿðÿ ?Àü ÿÿÿðàÿÀ  ÿøÀÿü À€þ  ÿÀÿÿð  ?ø  ÿÿ€ þ  ÿÿðÿ ?Àþ ÿÿÿð€ ÿÀ  ÿøÀÿü À€ü  ÿÀÿÿð  ?ð  ?ÿ€ þ  ÿÿøþ Àþ ÿÿÿð  À  ÿøàÿü €€ø  ÿÀÿÿð  ?à  ÿ€ þ  ÿÿøþ €þ ÿÿð  ?À  ÿðàÿü  €ð  ÿÀÿÿð  ?À  ÿ€  þ  ÿÿü x ÿ€þ ÿÿð   ?À  ÿðàÿü  €ð  ÿÀÿÿð  ?€  ÿ€   þ  ÿÿþ  ÿ€þ ÿÿð   À  ÿàðÿü  €àðÿÀÿÿð  ? Àÿ€ð þ  ÿÿÿ  ÿ€þ ÿÿð  À  ÿàðÿü  €àø ÿÀÿÿÿ€ÿ àÿ€ø ðÿÿÿÿ€ ÿ€þ ÿÿð €þ ÿàðÿü  €Àø ÿÀÿÿÿ€þ ?ðÿ€ü ðÿÿÿÿà ÿ€þ ÿÿð ÿÀþ ÿÀøÿü Ÿ€Àü ÿÀÿÿÿ€þ øÿ€ü ðÿÿÿÿÀ ÿ€þ ÿÿð ÿÀþ ÿÀøÿü ?ß€üü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿÿ€ ÿ€þ ÿÿðÿàþ ÿ€ø ÿü ?ÿ€ÿÿü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿþ  ÿ€þ ÿÿðÿàþ ÿ€ü ÿü ÿ€ÿÿü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿü   ÿ€þ ÿÿðÿàþ ÿ€ü ÿü ÿ€ÿÿø ÿÀÿÿÿ€øÿþ €þ ðÿÿÿø x €þ ÿÿðÿðþ ÿ ?þ ü ÿ€ÿÿ€ ÿÀÿÿÿ€øÿþ €þ ðÿÿÿøþ €þ ÿÿðÿðþ ÿ ?þ ü ÿÿ€ÿð  ÿÀÿÿÿ€øÿþ €þ ðÿÿÿðÿ ?€þ ÿÿðÿðþ ÿ ?þ ü ÿÿ€ÿ€  ÿÀÿÿÿ€øÿþ €þ ðÿÿÿðÿ ?€þ ÿÿðÿðþ þ    ?ü ÿÿ€ü   ÿÀÿÿÿ€øÿþ €þ ðÿÿÿðÿ€€þ ÿÿðÿðþ þ    ?ü ÿÿ€ø   ÿÀÿÿÿ€øÿþ €þ ðÿÿÿàÿ€€þ ÿÿðÿðþ ü    ü ÿÿ€ð   ÿÀÿÿÿ€øÿþ €þ ðÿÿÿàÿ€€þ ÿÿðÿðþ ü    ü ÿÿ€à  ÿÀÿÿÿ€øÿþ €þ ðÿÿÿàÿ€Àþ ÿÿÿðÿðþ ü    ü ÿÿ€À ü ÿÀÿÿÿ€øÿþ €þ ðÿÿÿàÿ€Àþ ÿÿÿðÿðþ ø    ü ÿÿ€Àü ÿÀÿÿÿ€øÿþ €þ ðÿÿÿàÿ€Àü ÿÿÿðÿðþ ø    ü ÿÿ€€ü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿàÿ€Àü ÿÿÿðÿðþ ð    ü ÿÿ€€ü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿàÿ€Àü ÿÿÿðÿàþ ðÿÿàü ÿÿ€€ü ÿÀÿÿÿ€ü ÿü ÿ€þ ðÿÿÿàÿ àüÿÿÿðÿàþ ðÿÿàü ÿÿ€€ø ÿÀÿÿÿ€þ øÿ€þ ðÿÿÿðÿ ?àøÿÿÿð ÿÀþ àÿÿàü ÿÿ€€ø ÿÀÿÿÿ€þ ?ðÿ€þ ðÿÿÿðþ ?àðÿÿÿð Àþ àÿÿðü ÿÿ€€ð ÿÀÿÿÿ€þ àÿ€þ ðÿÿÿð x ?ðàÿÿÿð €þ àÿÿðü ÿÿ€€À ÿÀÿÿÿ€ÿ Àÿ€þ ðóÿÿø   ð  ÿÿÿð  þ >Àÿÿðü ÿÿ€À   ÿÀÿÿÿ€ÿ€  ÿ€þ ð ÿÿü   ÿø  ÿÿÿð   þ  Àÿÿøü ÿÿ€À   ÿÀÿÿÿ€ÿÀ  ÿ€þ ø ÿÿü   ÿø  ÿÿÿð   ?ÿ  €ÿÿø ü ÿÿ€à  Àÿÿÿ€ÿà  ÿ€þ ø ÿÿþ  ÿü  ÿÿÿð  ÿ  €ÿÿø ü ÿÿ€ð  Àÿÿÿ€ÿð  ?ÿ€þ ü ÿÿÿ  ÿþ  ÿÿÿð  ÿÿ€ €ÿÿü ü ÿÿ€ø  Àÿÿÿ€ÿø  ÿÿ€þ ü ÿÿÿÀ ÿÿ€ ÿÿÿð€ÿÿ€  ÿÿü | ÿÿ€ü ? ?Àÿÿÿ€ÿÿ ÿÿ€þ ÿ ÿÿÿð ÿÿÀ ÿÿÿÿðÀÿÿà ÿÿÿÿÿÿÿÿÿÿÿÿÿ ÿÿÿÿÿÿÿÿÿÿÿÿàÿÿÿÿÿÿÿÿÀÿÿÿþ ÿÿÿøÿÿÿÿððÿÿøÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿðÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿ';
var canvas = document.createElement("canvas");
var ctx = canvas.getContext("2d");
canvas.width=60*8;//Image width (in bytes)
canvas.height=80;//Image height (in dots)
ctx.fillStyle ='white';
tspl_BytesTocanvas(canvas,s,1);

*/

function tspl_BytesTocanvas(canvas,s,mode) {
	//debugger;
	var widthPixels =canvas.width;
    var heightPixels =canvas.height;
	var context = canvas.getContext('2d');
	
	var x =0,y =1,bit =0,byte =0,byteVal = 0,xbit=0;
	for(byte=0;byte<s.length;byte++){
		
		byteVal =s.charCodeAt(byte);
		var bin=Number(byteVal).toString(2);
		for(bit =0;bit<8;bit++){
			if(x>=widthPixels){
				y++;
				x=0;
			}
			xbit=parseInt(bin.substr(bit,1));
			switch(mode){
				case 0: //OVERWRITE
				break;
				case 1: //OR
					xbit=xbit | 0;
				break;
				case 2: //XOR
					xbit=xbit ^ 1;
				break;
			}
			if(xbit===1){
				context.fillStyle = "rgb(255,255,255)";
			}else{
				context.fillStyle = "rgb(0,0,0)";
			}
			x++;
			context.fillRect( x, y, 1, 1 );
		}
		
	}
	return canvas.toDataURL( 'image/jpeg',1);
}

function tspl_canvasToBytes(canvas) {
	var widthPixels =canvas.width;
    var heightPixels =canvas.height;
	var widthBytes=((widthPixels + 7) / 8);
	var heightBytes=((heightPixels + 7) / 8);
	var context = canvas.getContext('2d');
	var imgData = new Array(heightPixels * widthPixels);
	for (var y = 0; y < heightPixels; y++) {
		for (x = 0; x < widthPixels; x++) {
			var p = context.getImageData(x,y, 1, 1).data,
			red =p[0],
			green =p[1],
			blue =p[2];
			var count = red + green + blue;
			var colour = 0;
			if (count > 383){ colour = 255;}
			imgData[y * widthPixels + x] =colour>0?1:0; ;//$image -> getPixel($x, $y) == 0 ? 0: 1;
		}
	}
	//console.log(imgData);
	
	var data =String.fromCharCode(0).repeat(widthBytes * heightPixels).split('');
	var x =0,y =0,bit =0,byte =0,byteVal = 0;
	do {
		byteVal |=imgData[y * widthPixels + x] << (7 - bit);
		x++;
		bit++;
		if (x >= widthPixels) {
			x = 0;
			y++;
			bit = 8;
			if (y >= heightPixels) {
				data[byte] = String.fromCharCode(byteVal);
				break;
			}
		}
		if (bit >= 8) {
			data[byte] = String.fromCharCode(byteVal);
			byteVal = 0;
			bit = 0;
			byte++;
		}
	} while (true);
	return data.join('');
}

function tspl_canvasToBytes2(canvas) {
	var widthPixels =canvas.width;
    var heightPixels =canvas.height;
	var widthBytes=((widthPixels + 7) / 8);
	var heightBytes=((heightPixels + 7) / 8);
	var context = canvas.getContext('2d');
	//var data =String.fromCharCode(0).repeat(widthBytes * heightPixels).split('');
	var x =0,y =0,bit =0,byte =0,byteVal = 0;
	var COLS = 248;
	var ROWS = 203;
	var THRESHOLD = 2500000000; // RGBA value in int form

	var img = new Array((COLS / 8) * ROWS);
	  for (var row = 0; row < ROWS; row++) {
		for (var byte = 0; byte < COLS / 8; byte++) {
		  let byteData = 0;
		  for (var bit = 0; bit < 8; bit++) {
			var pixelX = byte * 8 + bit;
			const pixelY = row;
			//const val = image.getPixelColor(pixelX, pixelY);
			var p = context.getImageData(pixelX,pixelY, 1, 1).data,
				red =p[0],
				green =p[1],
				blue =p[2];
			var rgb=0x1000000 * blue + 0x100 * green + 0x10000 *red ;
			var count = red + green + blue;
			var colour = 0;
			if (count > 383) colour = 255;
 
			
			if (rgb > THRESHOLD) {
			  byteData = byteData | (1 << (7 - bit));
			}
		  }
		  img[row * (COLS / 8) + byte] = byteData;
		  // console.log({ byteData, img, row, byte });
		}
	  }
	return img;//data.join('');
}

var sha256 = function sha256(ascii) {
    function rightRotate(value, amount) {
        return (value>>>amount) | (value<<(32 - amount));
    };
    
    var mathPow = Math.pow;
    var maxWord = mathPow(2, 32);
    var lengthProperty = 'length'
    var i, j; // Used as a counter across the whole file
    var result = ''

    var words = [];
    var asciiBitLength = ascii[lengthProperty]*8;
    
    //* caching results is optional - remove/add slash from front of this line to toggle
    // Initial hash value: first 32 bits of the fractional parts of the square roots of the first 8 primes
    // (we actually calculate the first 64, but extra values are just ignored)
    var hash = sha256.h = sha256.h || [];
    // Round constants: first 32 bits of the fractional parts of the cube roots of the first 64 primes
    var k = sha256.k = sha256.k || [];
    var primeCounter = k[lengthProperty];
    /*/
    var hash = [], k = [];
    var primeCounter = 0;
    //*/

    var isComposite = {};
    for (var candidate = 2; primeCounter < 64; candidate++) {
        if (!isComposite[candidate]) {
            for (i = 0; i < 313; i += candidate) {
                isComposite[i] = candidate;
            }
            hash[primeCounter] = (mathPow(candidate, .5)*maxWord)|0;
            k[primeCounter++] = (mathPow(candidate, 1/3)*maxWord)|0;
        }
    }
    
    ascii += '\x80' // Append Ƈ' bit (plus zero padding)
    while (ascii[lengthProperty]%64 - 56) ascii += '\x00' // More zero padding
    for (i = 0; i < ascii[lengthProperty]; i++) {
        j = ascii.charCodeAt(i);
        if (j>>8) return; // ASCII check: only accept characters in range 0-255
        words[i>>2] |= j << ((3 - i)%4)*8;
    }
    words[words[lengthProperty]] = ((asciiBitLength/maxWord)|0);
    words[words[lengthProperty]] = (asciiBitLength)
    
    // process each chunk
    for (j = 0; j < words[lengthProperty];) {
        var w = words.slice(j, j += 16); // The message is expanded into 64 words as part of the iteration
        var oldHash = hash;
        // This is now the undefinedworking hash", often labelled as variables a...g
        // (we have to truncate as well, otherwise extra entries at the end accumulate
        hash = hash.slice(0, 8);
        
        for (i = 0; i < 64; i++) {
            var i2 = i + j;
            // Expand the message into 64 words
            // Used below if 
            var w15 = w[i - 15], w2 = w[i - 2];

            // Iterate
            var a = hash[0], e = hash[4];
            var temp1 = hash[7]
                + (rightRotate(e, 6) ^ rightRotate(e, 11) ^ rightRotate(e, 25)) // S1
                + ((e&hash[5])^((~e)&hash[6])) // ch
                + k[i]
                // Expand the message schedule if needed
                + (w[i] = (i < 16) ? w[i] : (
                        w[i - 16]
                        + (rightRotate(w15, 7) ^ rightRotate(w15, 18) ^ (w15>>>3)) // s0
                        + w[i - 7]
                        + (rightRotate(w2, 17) ^ rightRotate(w2, 19) ^ (w2>>>10)) // s1
                    )|0
                );
            // This is only used once, so *could* be moved below, but it only saves 4 bytes and makes things unreadble
            var temp2 = (rightRotate(a, 2) ^ rightRotate(a, 13) ^ rightRotate(a, 22)) // S0
                + ((a&hash[1])^(a&hash[2])^(hash[1]&hash[2])); // maj
            
            hash = [(temp1 + temp2)|0].concat(hash); // We don't bother trimming off the extra ones, they're harmless as long as we're truncating when we do the slice()
            hash[4] = (hash[4] + temp1)|0;
        }
        
        for (i = 0; i < 8; i++) {
            hash[i] = (hash[i] + oldHash[i])|0;
        }
    }
    
    for (i = 0; i < 8; i++) {
        for (j = 3; j + 1; j--) {
            var b = (hash[i]>>(j*8))&255;
            result += ((b < 16) ? 0 : '') + b.toString(16);
        }
    }
    return result;
};





