var routes = [
  // Index page
  {
    path: '/',
    componentUrl: './pages/init.html',
    name: 'init',
    master(f7) {
      return f7.theme === 'aurora';
    },
  },
  
	   {
		path: '/home',
		componentUrl: './pages/home.html',
		name: 'home',
	  },
	  {
		path: '/register',
		componentUrl: './pages/user/register.html',
		name: 'register',
	  },
		{
		path: '/sign_in',
		componentUrl: './pages/user/sign_in.html',
		name: 'sign_in',
	  },
	  {
		path: '/profile',
		componentUrl: './pages/user/profile.html',
		name: 'profile',
	  },
	  {
		path: '/users',
		componentUrl: './pages/user/users.html',
		name: 'users',
	  },
	  {
		path: '/customers',
		componentUrl: './pages/accounts/customers.html',
		name: 'customers',
	  },
	  {
		path: '/suppliers',
		componentUrl: './pages/accounts/suppliers.html',
		name: 'suppliers',
	  },
	  {
		path: '/products/:is_pop?',
		componentUrl: './pages/stock/products.html',
		name: 'products',
	  },
	  {
		path: '/collection',
		componentUrl: './pages/card_col/collection.html',
		name: 'collection',
	  },
	  {
		path: '/return',
		componentUrl: './pages/card_col/return.html',
		name: 'return',
	  },
	  {
		path: '/receipts',
		componentUrl: './pages/accounts/receipts.html',
		name: 'receipts',
	  },
	  {
		path: '/payments',
		componentUrl: './pages/accounts/payments.html',
		name: 'payments',
	  },
	  {
		path: '/transfer',
		componentUrl: './pages/accounts/transfer.html',
		name: 'transfer',
	  },
	  {
		path: '/day_book',
		componentUrl: './pages/accounts/day_book.html',
		name: 'day_book',
	  },
	  {
		path: '/cash_book',
		componentUrl: './pages/accounts/cash_book.html',
		name: 'cash_book',
	  },
	  {
		path: '/ledger/:attrs?',
		componentUrl: './pages/accounts/ledger.html',
		name: 'ledger',
	  },
	  {
		path: '/collection_report',
		componentUrl: './pages/card_col/collection_report.html',
		name: 'collection_report',
	  },
	  {
		path: '/return_report',
		componentUrl: './pages/card_col/return_report.html',
		name: 'return_report',
	  },
	   {
		path: '/pending_report',
		componentUrl: './pages/card_col/pending_report.html',
		name: 'pending_report',
	  },
	   {
		path: '/stock_report',
		componentUrl: './pages/stock/stock_report.html',
		name: 'stock_report',
	  },
	   {
		path: '/balance_report',
		componentUrl: './pages/accounts/balance_report.html',
		name: 'balance_report',
	  },
		{
		path: '/configure',
		componentUrl: './pages/settings/configure.html',
		name: 'configure',
	  },
		{
		path: '/sms_template',
		componentUrl: './pages/settings/sms_template.html',
		name: 'sms_template',
	  },    
	   {
		path: '/print_settings',
		componentUrl: './pages/settings/print_settings.html',
		name: 'print_settings',
	  },
	  {
		path: '/warehouse',
		componentUrl: './pages/warehouse/warehouse.html',
		name: 'warehouse',
	  },
	  {
		path: '/warehouse_out',
		componentUrl: './pages/warehouse/warehouse_out.html',
		name: 'warehouse_out',
	  },
	  {
		path: '/warehouse_stock_report',
		componentUrl: './pages/warehouse/warehouse_stock_report.html',
		name: 'warehouse_stock_report',
	  },
	  {
		path: '/rental_issue',
		componentUrl: './pages/rental/rental_issue.html',
		name: 'rental_issue',
	  },
	   {
		path: '/accounts',
		componentUrl: './pages/accounts/accounts.html',
		name: 'accounts',
	  },
	  {
		path: '/rental_return',
		componentUrl: './pages/rental/rental_return.html',
		name: 'rental_return',
	  },
	  {
		path: '/rental_customer_register',
		componentUrl: './pages/rental/rental_customer_register.html',
		name: 'rental_customer_register',
	  },
	  {
		path: '/rental_customer_products',
		componentUrl: './pages/rental/rental_customer_products.html',
		name: 'rental_customer_products',
	  },
	  {
		path: '/rental_product_details',
		componentUrl: './pages/rental/rental_product_details.html',
		name: 'rental_product_details',
	  },
	  {
		path: '/developer',
		componentUrl: './pages/developer.html',
		name: 'developer',
	  },
	  {
		path: '/printing_count',
		componentUrl: './pages/settings/printing_count.html',
		name: 'printing_count',
	  },
	  {
		path: '/ticket_sale',
		componentUrl: './pages/ticket_sale/ticket_sale.html',
		name: 'ticket_sale',
	  },
	  {
		path: '/user_products',
		componentUrl: './pages/ticket_sale/user_products.html',
		name: 'user_products',
	  },
	  {
		path: '/discount_coupons',
		componentUrl: './pages/ticket_sale/discount_coupons.html',
		name: 'discount_coupons',
	  },
	  {
		path: '/ticket_sale_list',
		componentUrl: './pages/ticket_sale/ticket_sale_list.html',
		name: 'ticket_sale_list',
	  },
	  {
		path: '/ticket_sale_report',
		componentUrl: './pages/ticket_sale/ticket_sale_report.html',
		name: 'ticket_sale_report',
	  },
	  {
		path: '/single_sale',
		componentUrl: './pages/single_sale/single_sale.html',
		name: 'single_sale',
	  },
	  {
		path: '/single_purchase',
		componentUrl: './pages/single_sale/single_purchase.html',
		name: 'single_purchase',
	  },
	  {
		path: '/single_sale_stock_adj',
		componentUrl: './pages/single_sale/single_sale_stock_adj.html',
		name: 'single_sale_stock_adj',
	  },
	  {
		path: '/single_sale_customer_register',
		componentUrl: './pages/single_sale/single_sale_customer_register.html',
		name: 'single_sale_customer_register',
	  },
	  {
		path: '/sales_tax/:is_pop?',
		componentUrl: './pages/sales/sales_tax.html',
		name: 'sales_tax',
	  },
	  {
		path: '/sales_config',
		componentUrl: './pages/settings/sales_config.html',
		name: 'sales_config',
	  },
	  {
		path: '/units/:is_pop?',
		componentUrl: './pages/stock/units.html',
		name: 'units',
	  },
	  {
		path: '/document_types',
		componentUrl: './pages/sales/document_types.html',
		name: 'document_types',
	  },
	  {
		path: '/invoice/:doc_type?/:is_pos?',
		componentUrl: './pages/sales/invoice.html',
		name: 'invoice',
	  },	 
	  {
		path: '/invoice_print_html',
		componentUrl: './pages/sales/invoice_print_html.html',
		name: 'invoice_print_html',
	  },
	  {
		path: '/invoice_print_black_lines_head_cntr',
		componentUrl: './pages/sales/invoice_print_black_lines_head_cntr.html',
		name: 'invoice_print_black_lines_head_cntr',
	  },
	  {
		path: '/invoice_print_black_lines_head_cntr_2',
		componentUrl: './pages/sales/invoice_print_black_lines_head_cntr_2.html',
		name: 'invoice_print_black_lines_head_cntr_2',
	  },
	  {
		path: '/invoice_print_wo_dis_w_tot_head_cntr_vert_col',
		componentUrl: './pages/sales/invoice_print_wo_dis_w_tot_head_cntr_vert_col.html',
		name: 'invoice_print_wo_dis_w_tot_head_cntr_vert_col',
	  },
	  {
		path: '/invoice_print_quotation_1',
		componentUrl: './pages/sales/invoice_print_quotation_1.html',
		name: 'invoice_print_quotation_1',
	  },
	  {
		path: '/invoice_print_jewellery_inv',
		componentUrl: './pages/sales/invoice_print_jewellery_inv.html',
		name: 'invoice_print_jewellery_inv',
	  },
	  {
		path: '/invoice_print_jewellery_est',
		componentUrl: './pages/sales/invoice_print_jewellery_est.html',
		name: 'invoice_print_jewellery_est',
	  },
	  {
		path: '/invoice_print_vat',
		componentUrl: './pages/sales/invoice_print_vat.html',
		name: 'invoice_print_vat',
	  },
	  {
		path: '/invoice_print_w_qr_a4',
		componentUrl: './pages/sales/invoice_print_w_qr_a4.html',
		name: 'invoice_print_w_qr_a4',
	  },
	  {
		path: '/invoice_print_w_qr_a5',
		componentUrl: './pages/sales/invoice_print_w_qr_a5.html',
		name: 'invoice_print_w_qr_a5',
	  },
	  {
		path: '/invoice_print_ntax_mrp',
		componentUrl: './pages/sales/invoice_print_ntax_mrp.html',
		name: 'invoice_print_ntax_mrp',
	  },
	  {
		path: '/invoice_print_s1',
		componentUrl: './pages/sales/invoice_print_s1.html',
		name: 'invoice_print_s1',
	  },
	  {
		path: '/invoice_print_s2',
		componentUrl: './pages/sales/invoice_print_s2.html',
		name: 'invoice_print_s2',
	  },
	  {
		path: '/invoice_print_s3',
		componentUrl: './pages/sales/invoice_print_s3.html',
		name: 'invoice_print_s3',
	  },
	  {
		path: '/item_summary_sales',
		componentUrl: './pages/sales/item_summary_sales.html',
		name: 'item_summary_sales',
	  },
	  {
		path: '/item_details_sales',
		componentUrl: './pages/sales/item_details_sales.html',
		name: 'item_details_sales',
	  },
	  {
		path: '/gold_rates',
		componentUrl: './pages/settings/gold_rates.html',
		name: 'gold_rates',
	  },
	  {
		path: '/invoice_print_e_invoice',
		componentUrl: './pages/sales/invoice_print_e_invoice.html',
		name: 'invoice_print_e_invoice',
	  },
	  {
		path: '/invoice_print_e_invoice_2',
		componentUrl: './pages/sales/invoice_print_e_invoice_2.html',
		name: 'invoice_print_e_invoice_2',
	  },
	  
	  {
		path: '/invoice_print_e_way_bill',
		componentUrl: './pages/sales/invoice_print_e_way_bill.html',
		name: 'invoice_print_e_way_bill',
	  },
	  {
		path: '/invoice_print_e_way_bill_summary',
		componentUrl: './pages/sales/invoice_print_e_way_bill_summary.html',
		name: 'invoice_print_e_way_bill_summary',
	  },
	  
	  {
		path: '/tax_states',
		componentUrl: './pages/sales/tax_states.html',
		name: 'tax_states',
	  },
	  {
		path: '/branches',
		componentUrl: './pages/accounts/branches.html',
		name: 'branches',
	  },
	  {
		path: '/pdf_setup',
		componentUrl: './pages/settings/pdf_setup.html',
		name: 'pdf_setup',
	  },
	  {
		path: '/printer_setup',
		componentUrl: './pages/settings/printer_setup.html',
		name: 'printer_setup',
	  },
	  {
		path: '/barcode_setup',
		componentUrl: './pages/settings/barcode_setup.html',
		name: 'barcode_setup',
	  },
	  {
		path: '/stock_balance',
		componentUrl: './pages/stock/stock_balance.html',
		name: 'stock_balance',
	  },
	  {
		path: '/production',
		componentUrl: './pages/stock/production.html',
		name: 'production',
	  },
	  {
		path: '/production_print_html',
		componentUrl: './pages/stock/production_print_html.html',
		name: 'production_print_html',
	  },
	  {
		path: '/stock_transfer',
		componentUrl: './pages/stock/stock_transfer.html',
		name: 'stock_transfer',
	  },
	  {
		path: '/stock_transfer_print_html',
		componentUrl: './pages/stock/stock_transfer_print_html.html',
		name: 'stock_transfer_print_html',
	  },
	  {
		path: '/account_groups/:is_pop?',
		componentUrl: './pages/accounts/account_groups.html',
		name: 'account_groups',
	  },
	  {
		path: '/print_barcode',
		componentUrl: './pages/stock/print_barcode.html',
		name: 'print_barcode',
	  },
	  {
		path: '/print_barcode_html',
		componentUrl: './pages/stock/print_barcode_html.html',
		name: 'print_barcode_html',
	  },
	  {
		path: '/item_wise_profit',
		componentUrl: './pages/sales/item_wise_profit.html',
		name: 'item_wise_profit',
	  },
	  {
		path: '/invoice_wise_profit',
		componentUrl: './pages/sales/invoice_wise_profit.html',
		name: 'invoice_wise_profit',
	  },
	  {
		path: '/customer_register',
		componentUrl: './pages/sales/customer_register.html',
		name: 'customer_register',
	  },
	  {
		path: '/supplier_register',
		componentUrl: './pages/sales/supplier_register.html',
		name: 'supplier_register',
	  },
	  {
		path: '/customer_sales_summary',
		componentUrl: './pages/sales/customer_sales_summary.html',
		name: 'customer_sales_summary',
	  },
	  {
		path: '/customer_sales_details',
		componentUrl: './pages/sales/customer_sales_details.html',
		name: 'customer_sales_details',
	  },
	  {
		path: '/sales_summary/:transaction_nature?',
		componentUrl: './pages/sales/sales_summary.html',
		name: 'sales_summary',
	  },
	  {
		path: '/sales_summary_grouped_by_date/:transaction_nature?',
		componentUrl: './pages/sales/sales_summary_grouped_by_date.html',
		name: 'sales_summary_grouped_by_date',
	  },
	  {
		path: '/sales_details/:transaction_nature?',
		componentUrl: './pages/sales/sales_details.html',
		name: 'sales_details',
	  },
	  {
		path: '/stock_ledger',
		componentUrl: './pages/stock/stock_ledger.html',
		name: 'stock_ledger',
	  },
	  {
		path: '/stock_register',
		componentUrl: './pages/stock/stock_register.html',
		name: 'stock_register',
	  },
	  {
		path: '/stock_value_report',
		componentUrl: './pages/sales/stock_value_report.html',
		name: 'stock_value_report',
	  },
	  {
		path: '/product_groups/:is_pop?',
		componentUrl: './pages/stock/product_groups.html',
		name: 'product_groups',
	  },
	  
	   {
		path: '/profit_and_loss',
		componentUrl: './pages/accounts/profit_and_loss.html',
		name: 'profit_and_loss',
	  },
	  {
		path: '/profit_and_loss_monthly',
		componentUrl: './pages/accounts/profit_and_loss_monthly.html',
		name: 'profit_and_loss_monthly',
	  },
	  {
		path: '/trial_balance',
		componentUrl: './pages/accounts/trial_balance.html',
		name: 'trial_balance',
	  },
	  {
		path: '/balance_sheet',
		componentUrl: './pages/accounts/balance_sheet.html',
		name: 'balance_sheet',
	  },
	  {
		path: '/year_end',
		componentUrl: './pages/accounts/year_end.html',
		name: 'year_end',
	  },
	  {
		path: '/gstr1',
		componentUrl: './pages/sales/gstr1.html',
		name: 'gstr1',
	  },
	  {
		path: '/vat_summary',
		componentUrl: './pages/sales/vat_summary.html',
		name: 'vat_summary',
	  },
	  {
		path: '/liability_report',
		componentUrl: './pages/sales/liability_report.html',
		name: 'liability_report',
	  },
	   {
		path: '/liability_report_det/:attrs?',
		componentUrl: './pages/sales/liability_report_det.html',
		name: 'liability_report_det',
	  },
	  {
		path: '/user_perms',
		componentUrl: './pages/user/user_perms.html',
		name: 'user_perms',
	  },
	  {
		path: '/hospital_config',
		componentUrl: './pages/settings/hospital_config.html',
		name: 'hospital_config',
	  },
	  {
		path: '/patients/:is_customer/:is_pop?',
		componentUrl: './pages/hospital/patients.html',
		name: 'patients',
	  },
	  {
		path: '/patient_case_study',
		componentUrl: './pages/hospital/patient_case_study.html',
		name: 'patient_case_study',
	  },
	  {
		path: '/patient_bookings',
		componentUrl: './pages/hospital/patient_bookings.html',
		name: 'patient_bookings',
	  },
	  
	  {
		path: '/classes/:class_type/:is_pop?',
		componentUrl: './pages/school/classes.html',
		name: 'classes',
	  },
	  {
		path: '/resort_bookings',
		componentUrl: './pages/resort/resort_bookings.html',
		name: 'resort_bookings',
	  },
	  {
		path: '/resort_villas/:is_pop?',
		componentUrl: './pages/resort/resort_villas.html',
		name: 'resort_villas',
	  },
	  {
		path: '/sg_cert',
		componentUrl: './pages/sg_cert/sg_cert.html',
		name: 'sg_cert',
	  },
	  {
		path: '/sg_cert_print_html',
		componentUrl: './pages/sg_cert/sg_cert_print_html.html',
		name: 'sg_cert_print_html',
	  },
	  {
		path: '/custom_fields',
		componentUrl: './pages/settings/custom_fields.html',
		name: 'custom_fields',
	  },
	  {
		path: '/work_assignment',
		componentUrl: './pages/work/work_assignment.html',
		name: 'work_assignment',
	  },
	  {
		path: '/work_payment',
		componentUrl: './pages/work/work_payment.html',
		name: 'work_payment',
	  },
	  {
		path: '/work_report_customer',
		componentUrl: './pages/work/work_report_customer.html',
		name: 'work_report_customer',
	  },
	  {
		path: '/work_report_account',
		componentUrl: './pages/work/work_report_account.html',
		name: 'work_report_account',
	  },
	  {
		path: '/work_config',
		componentUrl: './pages/settings/work_config.html',
		name: 'work_config',
	  },
	  {
		path: '/work_register_account',
		componentUrl: './pages/work/work_register_account.html',
		name: 'work_register_account',
	  },
	  {
		path: '/work_account',
		componentUrl: './pages/work/work_account.html',
		name: 'work_account',
	  },
	  
	  
  // Default route (404 page). MUST BE THE LAST
  {
    path: '(.*)',
    url: './pages/404.html',
  },
];
