function fetch_json_sync(uri,data){
	if(typeof(data)==='object'){
		var _data='';
		for(var a in data){
			if(_data!==''){
				_data+='&';
			}
			_data+=a + '='+ encodeURIComponent(data[a]);
		}
		data=_data;
	}
	var request = new XMLHttpRequest();
	request.open("POST",uri, false); // third parameter indicates sync xhr. :(
	request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
	request.setRequestHeader("X-Requested-With", "XMLHttpRequest");
	request.send(data);
	if (request.status === 200) {
		return JSON.parse(request.responseText);
	}else{
		return [];
	}
}
function calc_amounts_to_tree_vbs(ar){
	var roots = [];
	var map =[];
	var node,parentIndex,i,j,k,ar_length=ar.length;
	for(i=0;i<ar_length;i++){
		ar[i].Amount=parseFloat(ar[i].Amount);
		
		node=ar[i];
		node.treelevel=node.treelevel===undefined?0:node.treelevel;
		node.folder=false;
		if(parseInt(ar[i].is_group)==1){
			node.folder=true;
		}
		if(node.parent_id<=0){
			roots.push(node);
		}
		parentIndex=-1;
		for(j=0;j<map.length;j++){
			if(map[j].ID==node.parent_id){
				parentIndex=map[j].index;
				break;
			}
		}
		if(parentIndex===-1){
			for(j=0;j<ar_length;j++){
				if(ar[j].ID==node.parent_id){
					parentIndex=j;
					break;
				}
			}
			map.push({ID:node.parent_id,index:parentIndex});
		}
		if(parentIndex!==-1){
			
			node.parent=ar[parentIndex];
			node.parent.children=node.parent.children===undefined?[]:node.parent.children;
			node.parent.treelevel=node.parent.treelevel===undefined?0:node.parent.treelevel;
			node.parent.folder=true;
			node.treelevel=node.parent.treelevel+1;
			
			node.parent.children.push(node);
		}
	}
	for(i=0;i<ar_length;i++){
		node=ar[i];
		if(parseInt(node.is_group)!==1 && node.parent){
			var parent=node.parent;
			while(true){
				parent.Amount+=node.Amount;
				parent=parent.parent;
				if(!parent){
					break;
				}
			}
		}
	}
	map =[];
	return roots;
}

function list_to_tree(list) {
	var map = {}, node, roots = [], i;
	for (i = 0; i < list.length; i += 1) {
		map[(list[i].ID+'')] = i; // initialize the map
	}
	for (i = 0; i < list.length; i += 1) {
		node = list[i];
		node.title=node.account_name;
		node.Amount=parseFloat(node.Amount);
		node.list_index=i;
		if(parseInt(node.isGroup)==1){
			node.folder=true;
		}
		node.haschild=false;
		if ((node.parent_id+'') !== "0" && list[map[(node.parent_id+'')]]) {
			list[map[(node.parent_id+'')]].folder=true;
			list[map[(node.parent_id+'')]].haschild=true;
			list[map[(node.parent_id+'')]].children=list[map[(node.parent_id+'')]].children || [];
			list[map[(node.parent_id+'')]].children.push(node);
			node.treelevel=list[map[(node.parent_id+'')]].treelevel+1;
			node.parent=list[map[(node.parent_id+'')]];
			
		} else {
			node.expanded=true;
			node.treelevel=0;
			roots.push(node);
		}
		//update_tree_parents_b(map,list,node.parent_id,node.Amount);
		 
	}
	return roots;
}

function build_flat_vbs_cd_to_root(flat, node,i,level,debit ){
	if (node.parent) {// && level>0
		var b=true;
		for(var j=i;j>=0;j--){
			if(flat[j].ID==node.ID){
				b=false;
				break;
			}
		}
		if(b){
			var data={};
			for(var a in node){
				if (a!=='children'){
					data[a]=node[a];
				}
			}
			data.children_index=[];
			////data.children_index.push(i);
			data.treelevel=level;
			data.Amount=0;
			data.changed=true;
			data.other_side=true;
			data.debit=debit;
			flat.splice(i,0,data);
		}
		build_flat_vbs_cd_to_root(flat,node.parent,i,level-1,debit );
	}
	return level;
}
 
function isExponential(num) {//isExponential(1.23e+5);     // true
	if (typeof num !== 'number') {
		return false; // Not a number
	}
	return num.toString().indexOf('e')>-1 || num.toString().indexOf('E')>-1;
}
function isValidAmount(num) {
	if(isExponential(num)){
		return false;
	}
	return num!==0;
}
function build_flat_vbs_cd(flat, parent,debit,account_type_based,level,min_level){
	if(level===undefined){
		level=0;
	}
	if(min_level===undefined){
		min_level=-1;
	}
	if(parent.children){
		for(var c=0;c<parent.children.length;c++){
			var node=parent.children[c];
			var b=true;
			if (node.Amount===0 && node.treelevel>min_level){
				b=false;
			}
			b=isValidAmount(node.Amount);
			if(account_type_based){
				//1=Asset,2=Liability,3=Income,4=Expense
				var account_type=parseInt(node.account_type);
				if(debit===true && (account_type===2 || account_type===3)){//Liability & Incomes
					b=false;
				}else if(!debit && (account_type===1 || account_type===4)){//Asset & Expenses
					b=false;
				}
				if(node.ID==126){
					//debugger;
				}
			}else{
				if(debit===true && node.Amount<0){
					b=false;
				}else if(!debit && node.Amount>0){
					b=false;
				}
			}
			
			if(b){
				var data={};
				for(var a in node){
					if (a!=='children'){
						data[a]=node[a];
					}
				}
				if(node.children || node.folder){
					data.Amount=0;
					data.changed=true;
				}
				data.children_index=[];
					b=true;
				var in_same_group=false;
				if(flat.length>0){
					var parent_id=data.parent_id;
					for(var i=flat.length-1;i>=0;i--){
						if(flat[i].ID==parent_id){
							in_same_group=true;
							if(flat[i].changed){
								//flat[i].Amount+=data.Amount;
								parent_id=flat[i].parent_id;
							}
						}
					}
					 
				}
				data.treelevel=level;
				data.debit=debit;
				 
				flat.push(data);
				 
				if(b && in_same_group===false){
					build_flat_vbs_cd_to_root(flat, parent,flat.length-1,level-1,debit);				
					/*
					var parent_id=data.parent_id;
					for(var i=flat.length-2;i>=0;i--){
						if(flat[i].ID==parent_id){
							if(flat[i].changed){
								flat[i].Amount+=data.Amount;
								parent_id=flat[i].parent_id;
							}
						}
					}
					*/
				}
			}
			if(node.children){
				build_flat_vbs_cd(flat, node,debit,account_type_based,level+1,min_level);
			}
		}
	}
	return flat;
}
function fix_amount(flat){
	var Amount=0;
	for(var j=flat.length-1;j>=0;j--){
		var data=flat[j];
		var parent_id=data.parent_id;
		if(parseInt(data.is_group)!==1){
			Amount+=data.Amount;
		}
		for(var i=j-1;i>=0;i--){
			if(flat[i].ID==parent_id){
				flat[i].Amount+=data.Amount;
				break;
			}
		}
	}
	return Amount;
}
 
function sort_tree(tree,prop,num,order){
	if(tree.length && tree.length>0){
		tree.sort(function(a,b){
			if(num){
				a[prop]=parseFloat(a[prop]);
				b[prop]=parseFloat(b[prop]);
			}
			//return a[prop]<b[prop] || a.folder?-1:1;
			if(order==='desc'){
				return a[prop]>b[prop]?-1:1;
			}else{
				return a[prop]<b[prop]?-1:1;
			}
		});
		tree.sort(function(a,b){
			return a.folder?-1:1;
		});
		for(var c=0;c<tree.length;c++){
			var node=tree[c];
			if(node.children){
				sort_tree(node.children,prop,num,order)
			}
		}
	}
}
function sort_tree_multi(tree,sortBy,parse_date,getFloat){
	if(sortBy.length===0){
		return;
	}
	if(tree.length && tree.length>0){
		tree.sort(function(a,b){
			var i = 0, result = 0;
			if(a.folder || b.folder){
				result=a.folder?-1:1;
			}
			while(i < sortBy.length) {
				var v1=0,v2=0;
				switch(sortBy[i].type){
					case 'date':case 'datetime':
						
						v1=parse_date(a[ sortBy[i].name ],'YYYY-MM-DD HH:mm:ss');
						v2=parse_date(b[ sortBy[i].name ],'YYYY-MM-DD HH:mm:ss');
					break;
					case 'int':case 'num':
						v1=getFloat(a[ sortBy[i].name ]);
						v2=getFloat(b[ sortBy[i].name ]);
					break;
					case 'str':
						v1=a[ sortBy[i].name ];
						v2=b[ sortBy[i].name ];
					break;
					default:
						if(typeof(sortBy[i].type)==='function'){
							var ret=sortBy[i].type('sort',a[ sortBy[i].name ],b[ sortBy[i].name ],a,b,sortBy[i]);
							
							v1=a[ sortBy[i].name ];
							v2=b[ sortBy[i].name ];
							if(ret && ret.length && ret.length>1){
								v1=ret[0];
								v2=ret[1];
							}
						}
					break;
				}
				if(sortBy[i].sort_order==='asc'){
					result =result || (v1< v2 ? -1 : (v1 > v2? 1 : 0));
				}else{
					result =result || (v1< v2 ? 1 : (v1 > v2? -1 : 0));
				}
				i++;
			}
			return result;
		});
		for(var c=0;c<tree.length;c++){
			var node=tree[c];
			if(node.children){
				sort_tree_multi(node.children,sortBy,parse_date,getFloat)
			}
		}
	}
}

function fix_index(flat){
	for(var i=flat.length-1;i>=0;i--){
		var node=flat[i];
		var parent_id=node.parent_id;
		var c=i;
		for(var j=i-1;j>=0;j--){
			if(!flat[j] || !flat[j].children_index){
				continue;
			}
			if(flat[j].children_index.indexOf(c)>-1){
				break;
			}
			if(flat[j].ID==parent_id){
				flat[j].children_index.push(c);
				parent_id=flat[j].parent_id;
				c=j;
			}
		}
	}
	return flat;
}
 
function build_flat_vbs_tb(flat, parent,level){
	if(level===undefined){
		level=0;
	}
	for(var c=0;c<parent.children.length;c++){
		var node=parent.children[c];
		var b=true;
		if (node.Amount===0){
			b=false;
		}
		if(b){
			var data={};
			for(var a in node){
				if (a!=='children'){
					data[a]=node[a];
				}
			}
			if(node.children){
				data.Amount=0;
				data.changed=true;
			}
			data.children_index=[];
			if(flat.length>0){
				var parent_id=data.parent_id;
				for(var i=flat.length-1;i>=0;i--){
					if(flat[i].ID==parent_id){
						flat[i].children_index.push(flat.length);
						break;
					}
				}
				var parent_id=data.parent_id;
				for(var i=flat.length-1;i>=0;i--){
					if(flat[i].ID==parent_id){
						if(flat[i].changed){
							flat[i].Amount+=data.Amount;
							parent_id=flat[i].parent_id;
						}
					}
				}
			}
			data.treelevel=level;
			flat.push(data);
		}
		if(node.children){
			build_flat_vbs_tb(flat, node,level+1);
		}
	}
	return flat;
}

self.onmessage = function(e) {
	//debugger;
	var options=e.data;
	var output_type=options.output_type;
	var tree_data=options.tree_data;
	var node_states=options.node_states;
	var round_num=undefined;
		eval("round_num=" + options.round_num);
	var group_top_levels=options.group_top_levels;
	var parse_date=undefined;
		eval("parse_date=" + options.parse_date);
	var getFloat=undefined;
		eval("getFloat=" + options.getFloat);	
	var sort_multi=undefined;
		eval("sort_multi=" + options.sort_multi);
	var parent_sort_by=options.parent_sort_by;
	var children_sort_by=options.children_sort_by;
	
	var show_sub_total=options.show_sub_total;
	var num_cols=options.num_cols;
	var init_loop_fn=undefined;
		eval('init_loop_fn=' + options.init_loop_fn);
	var receipt_cols=options.receipt_cols;
	var payment_cols=options.payment_cols;
	
	var process_flat_fn=undefined;
		eval('process_flat_fn=' + options.process_flat_fn);
	var account_type_based=options.account_type_based;
	var build_flat_fn=undefined;
		eval('build_flat_fn=' + options.build_flat_fn);
	var node_prefix=options.node_prefix;
	
	if(output_type==='flat'){
		//debugger;
		var totals={};
		for(var k=0;k<num_cols.length;k++){
			totals[num_cols[k]]=0;
		}
		for(var i=0;i<tree_data.length;i++){
			var item=tree_data[i];
			if(init_loop_fn){
				init_loop_fn(item);
			}
			for(var k=0;k<num_cols.length;k++){
				item[num_cols[k]]=parseFloat(item[num_cols[k]]);
				totals[num_cols[k]]+=item[num_cols[k]];
			}
		}
		
		function process_flat_data(data_out,receipts){
			tree_data.sort(function(a,b){
				var p=false;
				if(receipts){
					 p=a.receipt_parent_id<b.receipt_parent_id;
				}else{
					 p=a.payment_parent_id<b.payment_parent_id;
				}
				return p?-1:1;
			});
			parent='';
			pi=-1;
			 
			var total=0;
			var pid='',pn='';
			
			var parents=[];
			var children=[];
			for(var i=0;i<tree_data.length;i++){
				var item=tree_data[i];
				total=0;
				if(receipts){
					for(var k=0;k<num_cols.length;k++){
						if(receipt_cols.indexOf(num_cols[k])>-1){
							total+=item[num_cols[k]];
						}
					}
				}else{
					for(var k=0;k<num_cols.length;k++){
						if(payment_cols.indexOf(num_cols[k])>-1){
							total+=item[num_cols[k]];
						}
					}
				}
				if(total===0){
					continue;
				}
				 
				if(receipts){
					pid=item.receipt_parent_id;
					pn=item.receipt_parent;
				}else{
					pid=item.payment_parent_id;
					pn=item.payment_parent;
				}
				if(parent!=pid || parents.length===0){
					parent=pid;
					var a={};
					for(var o in item){
						a[o]='';//item[o];
					}
					a.ID=pid;
					a.account_name=pn;
					a.folder=true;
					a.treelevel=0;
					a.print_amount=false;
					a.children_index=[];
									 
					if(receipts){
						for(var k=0;k<num_cols.length;k++){
							if(receipt_cols.indexOf(num_cols[k])>-1){
								a[num_cols[k]]=0;
							}
						}
					}else{
						for(var k=0;k<num_cols.length;k++){
							if(payment_cols.indexOf(num_cols[k])>-1){
								a[num_cols[k]]=0;
							}
						}
					}
					parents.push(a);
					pi=parents.length-1;
				}
				var b={};
				for(var o in item){
					b[o]=item[o];
				}
				b.parent_id=pid;
				b.folder=false;
				b.treelevel=1;
				b.print_amount=true;
				b.children_index=[];
				b.ID=item.ID;
				 
				if(receipts){
					b.account_name=item.receipt_account;
													 
					for(var k=0;k<num_cols.length;k++){
						if(receipt_cols.indexOf(num_cols[k])>-1){
							b[num_cols[k]]=item[num_cols[k]];
							parents[pi][num_cols[k]]+=item[num_cols[k]];
						}
					}
				}else{
					b.account_name=item.payment_account;
									
					for(var k=0;k<num_cols.length;k++){
						if(payment_cols.indexOf(num_cols[k])>-1){
							b[num_cols[k]]=item[num_cols[k]];
							parents[pi][num_cols[k]]+=item[num_cols[k]];
						}
					}
				}
				  
				if(process_flat_fn){
					process_flat_fn(b,item,receipts);
				}
				
				children.push(b);
			}

			sort_multi(parents,parent_sort_by);
			sort_multi(children,children_sort_by);
			 
			var first_i=-1,last_i=-1;
			for(var i=0;i<parents.length;i++){
				var item=parents[i];
				for(var j=0;j<num_cols.length;j++){
					item[num_cols[j]]=round_num(item[num_cols[j]]);
				}
				 
				data_out.push(item);
				pi=data_out.length-1;
				last_i=-1;
				for(var j=0;j<children.length;j++){
					var item2=children[j];
					if(item2.parent_id==item.ID){
						for(var k=0;k<num_cols.length;k++){
							item2[num_cols[k]]=round_num(item2[num_cols[k]]);
						}
						  
						data_out.push(item2);
						last_i=data_out.length-1;
						data_out[pi].children_index.push(last_i);
					}
				}
				if(show_sub_total==1){
					var a={};
					for(var o in item){
						a[o]=item[o];
					}
					a.folder=true;
					a.treelevel=1;
					a.print_amount=true;
					a.children_index=[];
					a.ID='pt'+(pi+1);
					a.account_name='Sub Total';
					data_out.push(a);
					data_out[pi].children_index.push(data_out.length-1);
				}
			}
		}
 
		var data=[];
		var flat_receipts=[];
		var flat_payments=[];
		var parent='',pi=0;
		 
		process_flat_data(flat_receipts,true);
		process_flat_data(flat_payments,false);
		 
		var plevel=0,next_level=false;
		
		for(var i=0;i<flat_receipts.length;i++){
		 
			if(next_level){
				if(flat_receipts[i].treelevel>plevel){
					continue;
				}
				next_level=false;
			}
			if(node_states[node_prefix+'c'+flat_receipts[i].ID] && node_states[node_prefix+'c'+flat_receipts[i].ID].expanded===false){
				flat_receipts[i].print_amount=true;
				plevel=flat_receipts[i].treelevel;
				next_level=true;
			}
			
			var Name=flat_receipts[i].account_name;
			 
			var i2=flat_receipts[i].treelevel;
			var space=(new Array(i2*8).join(String.fromCharCode(160)));
			Name=space+Name;
			 
			var item=flat_receipts[i];
			var a={};
				for(var b in item){
					a[b]=item[b];
				}
			
			if (item.folder===true && !item.print_amount){
				for(var k=0;k<receipt_cols.length;k++){
					a[receipt_cols[k]]='';
				}
			}
				for(var k=0;k<payment_cols.length;k++){
					a[payment_cols[k]]='';
				}
				
			if(build_flat_fn){
				build_flat_fn(a,item,Name,space,true); 
			}
			
			a.credit_ID=flat_receipts[i].ID;
			a.credit_is_group=flat_receipts[i].folder;
			a.credit_children_index=flat_receipts[i].children_index;
			a.credit_expanded=node_states[node_prefix+'c'+flat_receipts[i].ID]?node_states[node_prefix+'c'+flat_receipts[i].ID].expanded:true;
			a.index=i;
			data.push(a);
		}
		 
		plevel=0,next_level=false;
		var j=0;
		for(var i=0;i<flat_payments.length;i++){
			 
			if(next_level){
				if(flat_payments[i].treelevel>plevel){
					continue;
				}
				next_level=false;
			}
			if(node_states[node_prefix+'d'+flat_payments[i].ID] && node_states[node_prefix+'d'+flat_payments[i].ID].expanded===false){
				flat_payments[i].print_amount=true;
				plevel=flat_payments[i].treelevel;
				next_level=true;
			}
			
			var Name=flat_payments[i].account_name;
			 
			var i2=flat_payments[i].treelevel;
			var space=(new Array(i2*8).join(String.fromCharCode(160)));
			Name=space+Name;
			
			var item=flat_payments[i];
			var a={};
				for(var b in item){
					a[b]=item[b];
				}
				
			if (item.folder===true && !item.print_amount){
				for(var k=0;k<payment_cols.length;k++){
					a[payment_cols[k]]='';
				}
			}
				for(var k=0;k<receipt_cols.length;k++){
					a[receipt_cols[k]]='';
				}
			
			if(build_flat_fn){			
				build_flat_fn(a,item,Name,space,false); 
			}
			
			a.debit_ID=flat_payments[i].ID;
			a.debit_is_group=flat_payments[i].folder;
			a.debit_children_index=flat_payments[i].children_index;
			a.debit_expanded=node_states[node_prefix+'d'+flat_payments[i].ID]?node_states[node_prefix+'d'+flat_payments[i].ID].expanded:true;
			a.index=i;
			if( j <data.length){
				var o=data[j];
				 
				for(var k=0;k<payment_cols.length;k++){
					o[payment_cols[k]]=a[payment_cols[k]];
				}
				o.debit_ID=a.debit_ID;
				o.debit_is_group=a.debit_is_group;
				o.debit_children_index=a.debit_children_index;
				o.debit_expanded=a.debit_expanded;
				o.index=a.index;
				data[j]=o;
			}else{
				data.push(a);
			}
			j++;
		}
		
		self.postMessage({data:data,totals});
	}
	else if(output_type==='semi-tree'){
		//debugger;
		var flat_data=[];
		var totals=new Array(tree_data.length);
		 
		for(var t=0;t<tree_data.length;t++){
			if(init_loop_fn){
				init_loop_fn(tree_data[t],t,options);
			}
			var t_data=calc_amounts_to_tree_vbs(tree_data[t]);
			//sort_tree(t_data,'sort_order',true);
			if(children_sort_by.length===0){
				children_sort_by=[{name:'sort_order',type:'num',sort_order:'asc'}];
			}
			sort_tree_multi(t_data,children_sort_by,parse_date,getFloat);
			
			var flat_debit=build_flat_vbs_cd([],t_data[0],true,account_type_based);
			var flat_credit=build_flat_vbs_cd([],t_data[0],false,account_type_based);
			 
			totals[t]={};
			totals[t].Debit=fix_amount(flat_debit);
			totals[t].Credit=fix_amount(flat_credit);
			
			if(process_flat_fn){
				var b=process_flat_fn(flat_debit,flat_credit,t,options,t_data);
				if(b===false){
					continue;
				}
			}
			 
			fix_index(flat_debit);
			fix_index(flat_credit);
			
			var data=[];
			 
			var plevel=0,next_level=false;
			for(var i=0;i<flat_debit.length;i++){
				var Debit= flat_debit[i].Amount;
				if (flat_debit[i].folder!==true){
					//totals.Debit+=Math.abs(Debit);
				}
				if(group_top_levels>0){
					if(flat_debit[i].treelevel>=group_top_levels){
						if(data.length>0 && data[data.length-1].index<i){
							data[data.length-1].debit_expanded=false;
							data[data.length-1].Debit=round_num(Math.abs(flat_debit[data[data.length-1].index].Amount));
						}else if(data.length>0){
							for(var k=data.length-1;k>=0;k--){
								if(flat_debit[i].parent_id===data[k].debit_ID){
									data[k].debit_expanded=false;
									data[k].Debit=round_num(Math.abs(flat_debit[i-1].Amount));
									break;
								}
							}
						}
						continue;
					}
				} 
				if(next_level){
					if(flat_debit[i].treelevel>plevel){
						continue;
					}
					next_level=false;
				}
				if(node_states[node_prefix+'d'+flat_debit[i].ID] && node_states[node_prefix+'d'+flat_debit[i].ID].expanded===false){
					flat_debit[i].print_amount=true;
					plevel=flat_debit[i].treelevel;
					next_level=true;
				}
				
				var Name=flat_debit[i].account_name;
				
				var i2=flat_debit[i].treelevel;
				var space=(new Array(i2*8).join(String.fromCharCode(160)));
				Name=space+Name;
				var a={
					debit_account:Name
					,Debit:round_num(Debit)
					,credit_account:''
					,Credit:''
				};
				
				if (flat_debit[i].folder===true && !flat_debit[i].print_amount){
					a.Debit='';
				}
				 
				a.debit_ID=flat_debit[i].ID;
				a.debit_is_group=flat_debit[i].folder;
				a.debit_children_index=flat_debit[i].children_index;
				a.debit_expanded=node_states[node_prefix+'d'+flat_debit[i].ID]?node_states[node_prefix+'d'+flat_debit[i].ID].expanded:true;
				a.index=i;
				
				if(build_flat_fn){
					build_flat_fn(a,flat_debit[i],Name,space,true,options); 
				}
				
				data.push(a);
			}
			  
			plevel=0,next_level=false;
			var j=0;
			for(var i=0;i<flat_credit.length;i++){
				var Credit=flat_credit[i].Amount;
				if (flat_credit[i].folder!==true){
					//totals.Credit+=Math.abs(Credit);
				}
				if(group_top_levels>0){
					if(flat_credit[i].treelevel>=group_top_levels){					
						if(data.length>0 && data[data.length-1].index<i){
							data[data.length-1].credit_expanded=false;
							data[data.length-1].Credit=round_num(Math.abs(flat_credit[data[data.length-1].index].Amount));
						}else if(data.length>0){
							for(var k=data.length-1;k>=0;k--){
								if(flat_credit[i].parent_id===data[k].credit_ID){
									data[k].credit_expanded=false;
									data[k].Credit=round_num(Math.abs(flat_credit[i-1].Amount));
									break;
								}
							}
						}
						continue;
					}
				} 
				if(next_level){
					if(flat_credit[i].treelevel>plevel){
						continue;
					}
					next_level=false;
				}
				if(node_states[node_prefix+'c'+flat_credit[i].ID] && node_states[node_prefix+'c'+flat_credit[i].ID].expanded===false){
					flat_credit[i].print_amount=true;
					plevel=flat_credit[i].treelevel;
					next_level=true;
				}
				
				var Name=flat_credit[i].account_name;
				 
				var i2=flat_credit[i].treelevel;
				var space=(new Array(i2*8).join(String.fromCharCode(160)));
				Name=space+Name;
				var a={
					debit_account:''
					,Debit:''
					,credit_account:Name 
					,Credit:round_num(Math.abs(Credit))
				};
				if (flat_credit[i].folder===true && !flat_credit[i].print_amount){
					a.Credit='';
				}
				if(flat_credit[i].parent_id==11600003 && Credit<0){
					a.Credit='-'+a.Credit;
				}
				 
				a.credit_ID=flat_credit[i].ID;
				a.credit_is_group=flat_credit[i].folder;
				a.credit_children_index=flat_credit[i].children_index;
				a.credit_expanded=node_states[node_prefix+'c'+flat_credit[i].ID]?node_states[node_prefix+'c'+flat_credit[i].ID].expanded:true;
				a.index=i;
				
				if(build_flat_fn){
					build_flat_fn(a,flat_credit[i],Name,space,false,options); 
				}
				
				if( j <data.length){
					var o=data[j];
					o.credit_account=a.credit_account;
					o.Credit=a.Credit;
					o.credit_ID=a.credit_ID;
					o.credit_is_group=a.credit_is_group;
					o.credit_children_index=a.credit_children_index;
					o.credit_expanded=a.credit_expanded;
					o.index=a.index;
					data[j]=o;
				}else{
					data.push(a);
				}
				j++;
			}
			flat_data=flat_data.concat(data);
		}
		 
		self.postMessage({data:flat_data,totals,options});
		
	}
	else if(output_type==='single-tree'){
		debugger;
		var totals={};
		 
		if(init_loop_fn){
		//	init_loop_fn(tree_data[t],t,options);
		}
		var t_data=calc_amounts_to_tree_vbs(tree_data);
		//sort_tree(t_data,'sort_order',true);
		if(children_sort_by.length===0){
			children_sort_by=[{name:'sort_order',type:'num',sort_order:'asc'}];
		}
		sort_tree_multi(t_data,children_sort_by,parse_date,getFloat);
		
		//var flat_debit=build_flat_vbs_cd([],t_data[0],true,account_type_based);
		//var flat_credit=build_flat_vbs_cd([],t_data[0],false,account_type_based);
		
		//var flat_data=build_flat_vbs_tb([], t_data[0] ).concat(build_flat_vbs_tb([], t_data[1] ));
		var flat_data=[];
		var tparent={};
		tparent.children=[];
		for(var i=0;i<t_data.length;i++){
			if(t_data[i].children){
				flat_data=flat_data.concat(build_flat_vbs_tb([],t_data[i]));
			}else{
				tparent.children.push(t_data[i]);
			}
		}
		flat_data=flat_data.concat(build_flat_vbs_tb([],tparent));
		
		if(process_flat_fn){
			//var b=process_flat_fn(flat_debit,flat_credit,t,options,t_data);
			//if(b===false){
			//	continue;
			//}
		}
		 
		fix_index(flat_data);
		 
		
		var data=[];
		 
		var plevel=0,next_level=false;
		var	tDebit=0;
		var	tCredit=0;
		//var p_ids='17,18,127,126'.split(',');
		var p_ids=[1,4];
		for(var i=0;i<flat_data.length;i++){
			var Amount=flat_data[i].Amount;
			if(!flat_data[i].folder){
				//if(p_ids.indexOf(flat_data[i].account_type)>-1){
					if(Amount>0){
						tDebit+=Amount;
					}else if(Amount<0){
						tCredit+=Math.abs(Amount);
					}
				//}
			}
			if(group_top_levels>0){
				if(flat_data[i].treelevel>=group_top_levels){
					data[data.length-1].expanded=false;
					var Amount=flat_data[data[data.length-1].index].Amount;
					if(Amount>0){
						data[data.length-1].Debit=round_num(Amount);
					}else if(Amount<0){
						data[data.length-1].Credit=round_num(Math.abs(Amount));
					}
					continue;
				}
			} 
			if(next_level){
				if(flat_data[i].treelevel>plevel){
					continue;
				}
				next_level=false;
			}
			if(node_states[flat_data[i].ID] && node_states[flat_data[i].ID].expanded===false){
				flat_data[i].print_amount=true;
				plevel=flat_data[i].treelevel;
				next_level=true;
			}
			
			var Name=flat_data[i].account_name;
			var Amount=flat_data[i].Amount;
			var i2=flat_data[i].treelevel;
			var space=(new Array(i2*8).join(String.fromCharCode(160)));
			Name=space+Name;
			var a={
				account_name:Name
				,Debit:''
				,Credit:''
			};
			if (flat_data[i].is_group==1 && !flat_data[i].print_amount){
			}else{
				if(Amount>0){
					a.Debit=round_num(Amount);
				}else{
					a.Credit=round_num(Math.abs(Amount));
				}
			}
			 
			a.ID=flat_data[i].ID;
			a.is_group=flat_data[i].is_group;
			a.children_index=flat_data[i].children_index;
			a.expanded=node_states[flat_data[i].ID]?node_states[flat_data[i].ID].expanded:true;
			a.index=i;
			
			if(build_flat_fn){
				build_flat_fn(a,flat_data[i],Name,space,options); 
			}
			
			data.push(a);
		}
		  
			
			 
		totals={};
		totals.Debit=tDebit;
		totals.Credit=tCredit;
			
		
		self.postMessage({data:data,totals,options});
		
	}

};

